/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.model;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.ext.variability.model.DeactivationSpecification;
import org.fortiss.tooling.ext.variability.model.OptionalVariationPointSpecification;
import org.fortiss.tooling.ext.variability.model.VariabilityModelElementFactory;
import org.fortiss.tooling.ext.variability.service.IDependingElementProviderService;
import org.fortiss.variability.model.IBindingStrategy;
import org.fortiss.variability.model.presence.ICompleteEvaluationContext;
import org.fortiss.variability.model.presence.PresenceCondition;

public class VariabilityStaticImpl {
    public static <E> E deactivateElement(E element) {
        if (element instanceof IModelElement) {
            DeactivationSpecification dSpec = VariabilityModelElementFactory.createDeactivationSpecification();
            ((IModelElement)element).addSpecification((IModelElementSpecification)dSpec);
        }
        if (element instanceof EObject) {
            for (EObject e : ((EObject)element).eContents()) {
                VariabilityStaticImpl.deactivateElement(e);
            }
        }
        return element;
    }

    public static IModelElement bindOptionalVariationPointSpecification(OptionalVariationPointSpecification varSpec, ICompleteEvaluationContext context, IBindingStrategy strategy) {
        PresenceCondition pc = varSpec.getPresenceCondition();
        IModelElement modelElement = (IModelElement)varSpec.eContainer();
        if (pc == null || pc.evaluate(context)) {
            EcoreUtil.delete((EObject)varSpec);
            return modelElement;
        }
        varSpec.getDependingElements().stream().forEach(e -> {
            Object object = strategy.doDeactivateElement(e);
        });
        return (IModelElement)strategy.doDeactivateElement((Object)modelElement);
    }

    public static EList<EObject> getDependingElements(OptionalVariationPointSpecification opt) {
        BasicEList ret = new BasicEList();
        ret.addAll(IDependingElementProviderService.getInstance().getDependingElements(opt.eContainer()));
        return ret;
    }
}

