/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.ext.variability.service.IDependingElementProvider;
import org.fortiss.tooling.ext.variability.service.IDependingElementProviderService;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.base.EObjectAwareServiceBase;
import org.fortiss.tooling.kernel.service.base.IObjectAware;

public class DependingElementProviderService
extends EObjectAwareServiceBase<IDependingElementProvider<EObject>>
implements IDependingElementProviderService {
    private static final DependingElementProviderService INSTANCE = new DependingElementProviderService();

    @Override
    public List<EObject> getDependingElements(EObject obj) {
        ArrayList<EObject> res = new ArrayList<EObject>();
        List registeredHandlers = this.getRegisteredHandlers(obj.getClass());
        if (registeredHandlers != null) {
            for (IDependingElementProvider p : registeredHandlers) {
                res.addAll(p.getDependingElements(obj));
            }
        }
        return res;
    }

    public String getIntrospectionLabel() {
        return "Depending Element Provider Service";
    }

    public String getIntrospectionDescription() {
        return "Service providing elements which depend on a given element. This service is used by the variability mechanisms in order to generate variants.";
    }

    protected String getExtensionPointName() {
        return "org.fortiss.af3.variability.dependingElementProvider";
    }

    protected String getConfigurationElementName() {
        return "dependingElementProvider";
    }

    protected String getHandlerClassAttribute() {
        return "provider";
    }

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    public static DependingElementProviderService getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerDependingElementProvider(IDependingElementProvider<? extends EObject> provider, Class<? extends EObject> cls) {
        this.addHandler(cls, (IObjectAware)provider);
    }
}

