/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.ext.variability.model.DeactivationSpecification;
import org.fortiss.tooling.ext.variability.model.OptionalVariationPointSpecification;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.features.AbstractFeatureModel;
import org.fortiss.variability.model.presence.PresenceCondition;
import org.fortiss.variability.model.presence.PresenceConditionTerm;
import org.fortiss.variability.presence.compiler.PresenceConditionCompiler;

public class VariabilityUtils {
    public static final String FEATURE_NAME_ERROR_MSG = "Feature names may only contain " + "[a-zA-Z\\d\\$&\\[\\]_\\-\\+@/\\\\,\\.=]".replaceAll("\\\\", "") + ", must not be empty and must be different from the keywords " + "OR|AND|NOT|DEFAULT".replaceAll("\\|", ", ") + ".";

    public static boolean isDeactivated(EObject eObj) {
        if (!(eObj instanceof IModelElement)) {
            return true;
        }
        IModelElement element = (IModelElement)eObj;
        DeactivationSpecification dSpec = (DeactivationSpecification)EcoreUtils.pickFirstInstanceOf(DeactivationSpecification.class, (List)element.getSpecifications());
        return dSpec != null;
    }

    public static boolean canContainVariability(EObject element) {
        if (element instanceof AbstractFeatureModel) {
            return true;
        }
        EObject topLevelElem = element;
        while (topLevelElem.eContainer() != null) {
            topLevelElem = topLevelElem.eContainer();
        }
        return EcoreUtils.getFirstChildWithType((EObject)topLevelElem, AbstractFeatureModel.class) != null;
    }

    public static boolean hasPresenceCondition(EObject elem) {
        if (!(elem instanceof IModelElement)) {
            return false;
        }
        return VariabilityUtils.getPresenceCondition((IModelElement)elem) != null;
    }

    public static PresenceCondition getPresenceCondition(IModelElement elem) {
        OptionalVariationPointSpecification opt = VariabilityUtils.getOptVarPointSpecification(elem);
        if (opt != null) {
            return opt.getPresenceCondition();
        }
        return null;
    }

    public static OptionalVariationPointSpecification getOptVarPointSpecification(IModelElement elem) {
        OptionalVariationPointSpecification opt = (OptionalVariationPointSpecification)EcoreUtils.pickFirstInstanceOf(OptionalVariationPointSpecification.class, (List)elem.getSpecifications());
        return opt;
    }

    public static boolean setPresenceCondition(IModelElement elem, String pcStr) {
        PresenceCondition oldPc;
        PresenceConditionCompiler comp = new PresenceConditionCompiler();
        PresenceCondition pc = comp.compilePresenceCondition((EObject)elem, pcStr);
        if (pc == null && comp.errors.size() > 0) {
            return false;
        }
        OptionalVariationPointSpecification spec = VariabilityUtils.getOptVarPointSpecification(elem);
        if (spec == null) {
            if (pc == null) {
                return true;
            }
            OptionalVariationPointSpecification finalSpec = spec = org.fortiss.tooling.ext.variability.model.VariabilityModelElementFactory.createOptionalVariationPointSpecification();
            ICommandStackService.getInstance().runAsCommand((EObject)elem, () -> elem.addSpecification((IModelElementSpecification)finalSpec));
        }
        if ((oldPc = spec.getPresenceCondition()) == null && pc == null) {
            return true;
        }
        if (oldPc == null || pc == null || !oldPc.getStringRepresentation().equals(pc.getStringRepresentation())) {
            OptionalVariationPointSpecification finalSpec = spec;
            ICommandStackService.getInstance().runAsCommand((EObject)elem, () -> finalSpec.setPresenceCondition(pc));
        }
        return true;
    }

    public static PresenceConditionTerm calculateGlobalPresenceCondition(EObject elem) {
        EObject parent = elem.eContainer();
        PresenceConditionTerm parentPC = null;
        if (parent != null) {
            parentPC = VariabilityUtils.calculateGlobalPresenceCondition(parent);
        }
        PresenceConditionTerm rest = null;
        if (VariabilityUtils.hasPresenceCondition(elem)) {
            rest = VariabilityUtils.getPresenceCondition((IModelElement)elem).resolveToFeatureLiterals();
        }
        if (parentPC != null) {
            if (rest != null) {
                return VariabilityModelElementFactory.createAndPC((PresenceConditionTerm)parentPC, (PresenceConditionTerm)rest, (String)"");
            }
            return parentPC;
        }
        return rest;
    }

    public static boolean containsVariability(IModelElement element) {
        return !EcoreUtils.getChildrenWithType((EObject)element, PresenceCondition.class).isEmpty();
    }
}

