/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.raspberry.ui.editor;

import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.TransmissionConnection;
import org.fortiss.af3.platform.raspberry.model.CanBus;
import org.fortiss.af3.platform.raspberry.model.RaspberryPi;
import org.fortiss.af3.platform.raspberry.model.RaspberryPiReceiverBase;
import org.fortiss.af3.platform.raspberry.model.RaspberryPiTransmitterBase;
import org.fortiss.tooling.base.ui.editor.fx.controller.EObjectDiagramController;
import org.fortiss.tooling.base.ui.editor.fx.controller.LayoutedContentAnchorageController;
import org.fortiss.tooling.base.ui.editor.fx.controller.LayoutedLineLinkBendPointController;
import org.fortiss.tooling.base.ui.editor.fx.controller.LayoutedRectangularResizableContentController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IControllerFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;

public class PlatformRaspberryPiControllerFactory
implements IControllerFactory {
    public IController createContentController(IContentMVCBundle modelBundle) {
        Object model = modelBundle.getModel();
        if (model instanceof RaspberryPi) {
            return new LayoutedRectangularResizableContentController(modelBundle, RaspberryPi.class);
        }
        if (model instanceof CanBus) {
            return new LayoutedRectangularResizableContentController(modelBundle, CanBus.class);
        }
        return null;
    }

    public IController createDiagramAnchorageController(IDiagramAnchorageMVCBundle modelBundle) {
        return null;
    }

    public IController createContentAnchorageController(IContentAnchorageMVCBundle modelBundle) {
        Object model = modelBundle.getModel();
        if (model instanceof RaspberryPiReceiverBase) {
            return new LayoutedContentAnchorageController(modelBundle, RaspberryPiReceiverBase.class);
        }
        if (model instanceof RaspberryPiTransmitterBase) {
            return new LayoutedContentAnchorageController(modelBundle, RaspberryPiTransmitterBase.class);
        }
        return null;
    }

    public IController createLinkController(ILinkMVCBundle modelBundle) {
        return new LayoutedLineLinkBendPointController(modelBundle, TransmissionConnection.class);
    }

    public IController createDiagramController(IDiagramMVCBundle diagramBundle) {
        return new EObjectDiagramController((IMVCBundle)diagramBundle, PlatformArchitecture.class);
    }
}

