/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.raspberry.ui.editor;

import org.fortiss.af3.platform.model.TransmissionConnection;
import org.fortiss.af3.platform.raspberry.model.CanBus;
import org.fortiss.af3.platform.raspberry.model.CanConnector;
import org.fortiss.af3.platform.raspberry.model.RaspberryPi;
import org.fortiss.af3.platform.raspberry.model.RaspberryPiReceiverBase;
import org.fortiss.af3.platform.raspberry.model.RaspberryPiTransmitterBase;
import org.fortiss.af3.platform.raspberry.model.brick.UIDReceiver;
import org.fortiss.af3.platform.raspberry.model.brick.UIDTtransmitter;
import org.fortiss.af3.platform.raspberry.model.gamepad.GamepadReceiverBase;
import org.fortiss.af3.platform.raspberry.model.rumblepad.RumbleMagnitudeStrong;
import org.fortiss.af3.platform.raspberry.model.rumblepad.RumbleMagnitudeWeak;
import org.fortiss.af3.platform.raspberry.model.rumblepad.RumblepadReceiverBase;
import org.fortiss.af3.platform.raspberry.ui.editor.visual.CanBusTransmissionUnitVisual;
import org.fortiss.af3.platform.raspberry.ui.editor.visual.RaspberryPiExecutionUnitVisual;
import org.fortiss.af3.platform.raspberry.ui.editor.visual.RaspberryPiReceiverVisual;
import org.fortiss.af3.platform.raspberry.ui.editor.visual.RaspberryPiTransceiverVisual;
import org.fortiss.af3.platform.raspberry.ui.editor.visual.RaspberryPiTransmitterVisual;
import org.fortiss.af3.platform.ui.editor.structure.visual.TransmissionConnectionVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IDiagramAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisualFactory;

public class PlatformRaspberryPiVisualFactory
implements IVisualFactory {
    public IContentVisual createContentVisual(IContentMVCBundle modelBundle) {
        Object modelObj = modelBundle.getModel();
        if (modelObj instanceof RaspberryPi) {
            return new RaspberryPiExecutionUnitVisual(modelBundle);
        }
        if (modelObj instanceof CanBus) {
            return new CanBusTransmissionUnitVisual(modelBundle);
        }
        return null;
    }

    public IDiagramAnchorageVisual createDiagramAnchorageVisual(IDiagramAnchorageMVCBundle modelBundle) {
        return null;
    }

    public IContentAnchorageVisual createContentAnchorageVisual(IContentAnchorageMVCBundle modelBundle) {
        Object modelObj = modelBundle.getModel();
        if (modelObj instanceof RaspberryPiTransmitterBase || modelObj instanceof RumbleMagnitudeStrong || modelObj instanceof RumbleMagnitudeWeak || modelObj instanceof UIDTtransmitter) {
            return new RaspberryPiTransmitterVisual(modelBundle);
        }
        if (modelObj instanceof RaspberryPiReceiverBase || modelObj instanceof GamepadReceiverBase || modelObj instanceof RumblepadReceiverBase || modelObj instanceof UIDReceiver) {
            return new RaspberryPiReceiverVisual(modelBundle);
        }
        if (modelObj instanceof CanConnector) {
            return new RaspberryPiTransceiverVisual(modelBundle);
        }
        return null;
    }

    public ILinkVisual createLinkVisual(ILinkMVCBundle modelBundle) {
        Object modelObj = modelBundle.getModel();
        if (modelObj instanceof TransmissionConnection) {
            return new TransmissionConnectionVisual(modelBundle);
        }
        return null;
    }
}

