/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.raspberry.ui.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationEntry;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.platform.model.allocation.OutputPortToTransmitterAllocationEntry;
import org.fortiss.af3.platform.raspberry.model.RaspberryPi;
import org.fortiss.af3.platform.raspberry.model.controlcenter.ControlCenterUpstreamOutput;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.OffsetOrientation;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.model.layout.Points;
import org.fortiss.tooling.base.model.layout.Rectangle;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public final class ComponentArchitectureExporter
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        ComponentToExecutionUnitAllocationTable ca2hw;
        EList c2eAllocations;
        if (selection instanceof ComponentToExecutionUnitAllocationTable && (c2eAllocations = (ca2hw = (ComponentToExecutionUnitAllocationTable)selection).getAllocationEntries(ComponentToExecutionUnitAllocationEntry.class)).size() == 1 && ((ComponentToExecutionUnitAllocationEntry)c2eAllocations.get(0)).getComponents().size() == 1) {
            return Arrays.asList(new ActionContributionItem((IAction)new ExportAction(ca2hw)));
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "bottommost";
    }

    private static class ExportAction
    extends Action {
        private final ComponentToExecutionUnitAllocationTable ca2hw;

        public ExportAction(ComponentToExecutionUnitAllocationTable ca2hw) {
            this.ca2hw = ca2hw;
            this.setText("Export for SystemFocus Viewer");
        }

        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dialog = new FileDialog(shell, 8192);
            dialog.setFileName(this.ca2hw.getName() + ".sf1viewer");
            String fileName = dialog.open();
            if (fileName == null) {
                return;
            }
            File exportFile = new File(fileName);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileOutputStream outputStream = new FileOutputStream(exportFile);){
                    this.getPropertiesFor().storeToXML(outputStream, this.ca2hw.getComment());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace(System.err);
            }
        }

        private Properties getPropertiesFor() {
            Properties props = new Properties();
            ComponentToExecutionUnitAllocationEntry allocs = (ComponentToExecutionUnitAllocationEntry)this.ca2hw.getAllocationEntries(ComponentToExecutionUnitAllocationEntry.class).get(0);
            this.writeParentComponent((Component)allocs.getComponents().get(0), props);
            if (allocs.getExecutionUnit() instanceof RaspberryPi) {
                RaspberryPi pi = (RaspberryPi)allocs.getExecutionUnit();
                props.setProperty("server.ip", pi.getControlcenterServerAddress());
                props.setProperty("server.port", pi.getControlcenterServerPort());
            }
            return props;
        }

        private void writeParentComponent(Component cmp, Properties props) {
            props.setProperty("parent.name", cmp.getName());
            props.setProperty("parent.subcomponents", "" + cmp.getSubComponents().size());
            int localIndex = 0;
            for (Component sc : cmp.getSubComponents()) {
                this.writeSubComponent(sc, localIndex, props);
                ++localIndex;
            }
            props.setProperty("parent.ports", "" + cmp.getConnectors().size());
            localIndex = 0;
            for (IConnector connector : cmp.getConnectors()) {
                Port p = (Port)connector;
                this.writeParentPort(p, "parent." + localIndex, props);
                ++localIndex;
            }
            props.setProperty("parent.channels", "" + cmp.getChannels().size());
            localIndex = 0;
            for (Channel ch : cmp.getChannels()) {
                this.writeChannel(ch, "channel." + localIndex, props);
                ++localIndex;
            }
        }

        private void writeChannel(Channel ch, String prefix, Properties props) {
            props.setProperty(prefix + ".name", ch.getName());
            props.setProperty(prefix + ".src", "" + ch.getSource().getId());
            props.setProperty(prefix + ".trg", "" + ch.getTarget().getId());
            Points pts = LayoutDataUtils.getConnectionPoints((ILayoutedModelElement)ch);
            props.setProperty(prefix + ".bendpoints", "" + pts.getPoints().size());
            int localIndex = 0;
            for (Point pt : pts.getPoints()) {
                String ptPrefix = prefix + "." + localIndex;
                props.setProperty(ptPrefix + ".x", "" + pt.getX());
                props.setProperty(ptPrefix + ".y", "" + pt.getY());
                ++localIndex;
            }
        }

        private void writeSubComponent(Component sc, int localIndex, Properties props) {
            String prefix = "component." + localIndex;
            props.setProperty(prefix + ".name", sc.getName());
            this.writeBounds((ILayoutedModelElement)sc, prefix, props);
            String t = "c";
            if (sc.getSubComponents().isEmpty()) {
                t = sc.isStronglyCausal() ? "s" : "w";
            }
            props.setProperty(prefix + ".type", t);
            int ports = sc.getConnectors().size();
            props.setProperty(prefix + ".ports", "" + ports);
            int i = 0;
            while (i < ports) {
                Port p = (Port)sc.getConnectors().get(i);
                this.writeSubComponentPort(p, prefix + "." + i, props);
                ++i;
            }
        }

        private void writeSubComponentPort(Port p, String prefix, Properties props) {
            props.setProperty(prefix + ".name", p.getName());
            props.setProperty(prefix + ".uid", "" + p.getId());
            OffsetOrientation oo = LayoutDataUtils.getConnectorOffsetOrientation((ILayoutedModelElement)p);
            props.setProperty(prefix + ".side", this.convertOrientation(oo.getOrientation()));
            props.setProperty(prefix + ".offset", "" + oo.getOffset());
            props.setProperty(prefix + ".w", "24");
            props.setProperty(prefix + ".h", "24");
            boolean dir = p instanceof InputPort;
            props.setProperty(prefix + ".dir", dir ? "input" : "output");
        }

        private void writeParentPort(Port p, String prefix, Properties props) {
            props.setProperty(prefix + ".name", p.getName());
            props.setProperty(prefix + ".uid", "" + p.getId());
            Point pos = LayoutDataUtils.getNodePosition((ILayoutedModelElement)p);
            props.setProperty(prefix + ".x", "" + pos.getX());
            props.setProperty(prefix + ".y", "" + pos.getY());
            props.setProperty(prefix + ".w", "24");
            props.setProperty(prefix + ".h", "24");
            boolean dir = p instanceof InputPort;
            props.setProperty(prefix + ".dir", dir ? "input" : "output");
            if (p instanceof OutputPort) {
                block0: for (OutputPortToTransmitterAllocationEntry entry : this.ca2hw.getAllocationEntries(OutputPortToTransmitterAllocationEntry.class)) {
                    for (OutputPort outputPort : entry.getOutputPorts()) {
                        if (outputPort != p || !(entry.getTransmitter() instanceof ControlCenterUpstreamOutput)) continue;
                        props.setProperty(prefix + ".ccid", p.getName());
                        break block0;
                    }
                }
            }
        }

        private String convertOrientation(EOrientation orientation) {
            switch (orientation) {
                case EAST: {
                    return "RIGHT";
                }
                case NORTH: {
                    return "TOP";
                }
                case SOUTH: {
                    return "BOTTOM";
                }
            }
            return "LEFT";
        }

        private void writeBounds(ILayoutedModelElement sc, String prefix, Properties props) {
            Rectangle bounds = LayoutDataUtils.getNodeBounds((ILayoutedModelElement)sc);
            props.setProperty(prefix + ".x", "" + bounds.getX());
            props.setProperty(prefix + ".y", "" + bounds.getY());
            props.setProperty(prefix + ".w", "" + bounds.getWidth());
            props.setProperty(prefix + ".h", "" + bounds.getHeight());
        }
    }
}

