/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.partition.ui;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fortiss.af3.partition.ui.DefaultStyle;

public class PartitionRectangle
extends Shape {
    private int cornerRadius;
    private Insets insets;

    public PartitionRectangle(int cornerRadius, Insets insets) {
        this.cornerRadius = cornerRadius;
        this.insets = insets;
    }

    protected void fillShape(Graphics gfx) {
        gfx.pushState();
        gfx.fillRoundRectangle(this.getCroppedBounds(), this.cornerRadius, this.cornerRadius);
        gfx.fillRectangle(this.getCroppedBounds());
        gfx.setForegroundColor(DefaultStyle.PARTITION_FOREGROUND);
        gfx.setAlpha(180);
        gfx.fillGradient(this.getCroppedBounds(), true);
        gfx.popState();
    }

    protected void outlineShape(Graphics gfx) {
        gfx.pushState();
        gfx.setAntialias(1);
        gfx.drawRoundRectangle(this.getCroppedBounds().resize(-1, -1), this.cornerRadius, this.cornerRadius);
        gfx.drawRectangle(this.getCroppedBounds());
        gfx.popState();
    }

    protected Rectangle getCroppedBounds() {
        return this.bounds.getShrinked(this.insets);
    }
}

