/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.partition.ui.editor.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.fortiss.af3.partition.model.MemoryArea;
import org.fortiss.af3.partition.model.MemoryAreaChannel;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.model.PartitionChannel;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelFactory;
import org.fortiss.tooling.common.util.LambdaUtils;

public final class PartitionModelFactory
implements IModelFactory {
    private final PartitionArchitecture rootElement;

    public PartitionModelFactory(PartitionArchitecture root) {
        this.rootElement = Objects.requireNonNull(root);
    }

    public Object getRootModel() {
        return this.rootElement;
    }

    public List<?> getContentModels() {
        ArrayList rval = new ArrayList();
        rval.addAll(this.rootElement.getPartitions());
        rval.addAll(this.rootElement.getMemoryAreas());
        return rval;
    }

    public List<?> getDiagramAnchorageModels() {
        return Collections.emptyList();
    }

    public List<?> getContentAnchorageModels(Object parent) {
        if (ReflectionUtils.isInstanceOfAny((Object)parent, (Class[])new Class[]{Partition.class, MemoryArea.class})) {
            return ((IHierarchicElement)parent).getConnectors();
        }
        return Collections.emptyList();
    }

    public List<?> getLinkModels() {
        return LambdaUtils.filterList((Collection)this.rootElement.getConnections(), c -> this.filterPartiallyInitializedConnections((IConnection)c));
    }

    private boolean filterPartiallyInitializedConnections(IConnection c) {
        return c.getSource() != null && c.getTarget() != null && c.eContainer() != null;
    }

    public Object getLinkStart(Object link) {
        if (link instanceof PartitionChannel) {
            return ((PartitionChannel)link).getSource();
        }
        if (link instanceof MemoryAreaChannel) {
            return ((MemoryAreaChannel)link).getSource();
        }
        return null;
    }

    public Object getLinkEnd(Object link) {
        if (link instanceof PartitionChannel) {
            return ((PartitionChannel)link).getTarget();
        }
        if (link instanceof MemoryAreaChannel) {
            return ((MemoryAreaChannel)link).getTarget();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public void update() {
    }
}

