/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.compose;

import java.util.Map;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.IComponentBehaviorDefinitionSpecification;
import org.fortiss.af3.component.reuse.ComponentReuseProvider;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.tooling.base.compose.HierarchicElementCompositorBase;
import org.fortiss.tooling.base.compose.LogMessageUserInteractionContext;
import org.fortiss.tooling.base.compose.ModelElementWithRefCopyMessage;
import org.fortiss.tooling.base.dnd.ElementDropContext;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.BaseModelElementUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.RectangleLayoutUtils;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ILogMessageContext;
import org.fortiss.tooling.kernel.extension.data.LogMessage;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.service.ILoggingService;
import org.fortiss.tooling.kernel.utils.CompositionUtils;

public class ComponentCompositor
extends HierarchicElementCompositorBase<Component> {
    public boolean canCompose(Component container, EObject contained, IElementCompositionContext context) {
        if (context instanceof ElementDropContext && contained instanceof Component && ((ElementDropContext)context).getDropTarget() instanceof IComponentBehaviorDefinitionSpecification) {
            return container.getSpecifications().size() == 0;
        }
        if (context == null && contained instanceof Component) {
            return !ComponentArchitectureUtils.hasBehaviorDefinitionSpecification(container);
        }
        if (ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification(container)) {
            return false;
        }
        return this.isCorrectElementClass(contained);
    }

    public boolean compose(Component container, EObject contained, IElementCompositionContext context) {
        super.compose((EObject)container, contained, context);
        if (contained instanceof Component) {
            Component component;
            Component sanitizedContainer = container;
            if (context instanceof CompositionUtils.PasteContext) {
                CompositionUtils.PasteContext pasteCtx = (CompositionUtils.PasteContext)context;
                for (Map.Entry entry : pasteCtx.copier.entrySet()) {
                    EObject key = (EObject)entry.getKey();
                    if (!(key instanceof Component) || ((Component)key).getId() != container.getId() || !((EObject)entry.getValue()).equals(contained) || pasteCtx.editedObj.equals(container)) continue;
                    sanitizedContainer = container.getParentComponent();
                    LayoutDataUtils.moveNode((ILayoutedModelElement)((Component)contained), (int)10, (int)10);
                }
            }
            if (BaseModelElementUtils.removeModelElementReferenceSpecifications((IModelElement)(component = (Component)contained))) {
                LogMessageUserInteractionContext msgContext = context instanceof ElementDropContext ? new LogMessageUserInteractionContext() : null;
                ILoggingService.getInstance().processMessage((LogMessage)new ModelElementWithRefCopyMessage(), (ILogMessageContext)msgContext);
            }
            LayoutDataUtils.layoutModelElement((EObject)component, (IElementCompositionContext)context);
            if (ReuseLibraryUtilsBasics.isCorrectReuseElement((EObject)contained)) {
                ComponentReuseProvider.updateRecursivelyAllPortTypes((Component)contained, (EObject)container);
            }
            sanitizedContainer.getContainedElements().add((Object)component);
            return true;
        }
        if (contained instanceof Port) {
            Port port = (Port)contained;
            ComponentCompositor.avoidDuplicatePortName(port, container);
            if (context instanceof ElementDropContext) {
                ElementDropContext ctx = (ElementDropContext)context;
                if (ctx.isRoot()) {
                    RectangleLayoutUtils.layoutNodeInRoot((ILayoutedModelElement)port, (ElementDropContext)ctx, (int)12, (boolean)true);
                } else {
                    Point ctxPosition = ctx.getPosition();
                    if (((ElementDropContext)context).isRootFigureCanvas()) {
                        ctxPosition.translate(ctx.getViewLocationZoomed());
                    }
                    RectangleLayoutUtils.layoutConnectorInRectangle((ILayoutedModelElement)port, (ILayoutedModelElement)container, (Point)ctxPosition);
                }
            }
            container.getConnectors().add((Object)port);
            return true;
        }
        return false;
    }

    static void avoidDuplicatePortName(Port port, Component container) {
        if (port.getComponent() == container) {
            return;
        }
        int num = 1;
        String orig = port.getName();
        while (container.findInputPort(port.getName()) != null || container.findOutputPort(port.getName()) != null) {
            port.setName(orig + num);
            ++num;
        }
    }

    public boolean canComposePrototype(Prototype prototype) {
        return this.isCorrectElementClass(prototype.getPrototype());
    }

    private boolean isCorrectElementClass(EObject element) {
        return ReflectionUtils.isInstanceOfAny((Object)element, (Class[])new Class[]{Component.class, InputPort.class, OutputPort.class});
    }

    public boolean canDecompose(EObject contained) {
        if (contained instanceof Port) {
            return !ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification(((Port)contained).getComponent());
        }
        return this.isCorrectElementClass(contained);
    }
}

