/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.compose;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.component.utils.ComponentUtils;
import org.fortiss.tooling.base.compose.ConnectionCompositorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.ext.variability.util.VariabilityUtils;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public class PortConnectionCompositor
extends ConnectionCompositorBase<Component, Port, Port> {
    public boolean canConnect(Port source, Port target, Component parent, IConnectionCompositionContext context) {
        Component parentComp = this.getConnectionContainer(source, target);
        return this.canConnect(source, target, parentComp);
    }

    public boolean connect(Port source, Port target, Component uselessParent, IConnectionCompositionContext context) {
        Component parentComp = this.getConnectionContainer(source, target);
        ITopLevelElement topElement = IPersistencyService.getInstance().getTopLevelElementFor((EObject)source);
        if (topElement != null) {
            topElement.prepareIDs((EObject)source);
            topElement.prepareIDs((EObject)target);
        }
        this.createConnection(source, target, parentComp, topElement);
        return true;
    }

    protected IConnection createConnection(Port source, Port target, Component parent, ITopLevelElement topElement) {
        if (!this.canConnect(source, target, parent)) {
            throw new OperationCanceledException();
        }
        IConnection connection = this.createConnection();
        if (topElement != null) {
            topElement.prepareIDs((EObject)connection);
        }
        ((Channel)connection).setName(source.getName());
        parent.getConnections().add((Object)connection);
        boolean sourceIsParentPort = source.eContainer() == parent;
        boolean sourceIsOutputPort = source instanceof OutputPort;
        if (sourceIsOutputPort != sourceIsParentPort) {
            connection.setSource((IConnector)source);
            connection.setTarget((IConnector)target);
        } else {
            connection.setSource((IConnector)target);
            connection.setTarget((IConnector)source);
        }
        return connection;
    }

    public boolean canReconnect(EObject connection, Port source, Port target, IConnectionCompositionContext context) {
        EObject parent = connection.eContainer();
        if (parent instanceof Component && connection instanceof IConnection) {
            Port sourcePort = source;
            Port targetPort = target;
            IConnection con = (IConnection)connection;
            EList<Channel> incomingChannels = targetPort.getIncomingChannels();
            if (incomingChannels.contains((Object)connection)) {
                if (con.getSource() == source) {
                    return true;
                }
                return this.hasCorrectDirection(sourcePort, targetPort, (Component)parent);
            }
            return this.canConnect(source, target, (Component)parent);
        }
        return super.canReconnect(connection, (EObject)source, (EObject)target, context);
    }

    public boolean reconnect(EObject connection, Port source, Port target, IConnectionCompositionContext context) {
        if (connection instanceof IConnection) {
            IConnection iConnection = (IConnection)connection;
            if (iConnection.getSource() == source) {
                iConnection.setTarget((IConnector)target);
                return true;
            }
            iConnection.setSource((IConnector)source);
            return true;
        }
        return false;
    }

    private boolean canConnect(Port sourcePort, Port targetPort, Component parentComponent) {
        boolean sourceIsParentPort;
        if (!this.hasCorrectDirection(sourcePort, targetPort, parentComponent)) {
            return false;
        }
        Port actualTargetPort = targetPort;
        boolean bl = sourceIsParentPort = sourcePort.eContainer() == parentComponent;
        if (sourceIsParentPort && sourcePort instanceof OutputPort || !sourceIsParentPort && sourcePort instanceof InputPort) {
            actualTargetPort = sourcePort;
        }
        return actualTargetPort.getIncomingChannels().size() < 1 || !actualTargetPort.getIncomingChannels().stream().anyMatch(c -> !VariabilityUtils.hasPresenceCondition((EObject)c) && !VariabilityUtils.hasPresenceCondition((EObject)c.getSource()) && !VariabilityUtils.hasPresenceCondition((EObject)c.getSource().eContainer()));
    }

    private boolean hasCorrectDirection(Port sourcePort, Port targetPort, Component parentComponent) {
        boolean targetIsInput;
        Component sourceComponent = sourcePort.getComponent();
        Component targetComponent = targetPort.getComponent();
        boolean sourceIsParentComponentPort = parentComponent.equals(sourceComponent);
        boolean targetIsParentComponentPort = parentComponent.equals(targetComponent);
        boolean sourceIsOutput = sourceIsParentComponentPort ? sourcePort instanceof InputPort : sourcePort instanceof OutputPort;
        boolean bl = targetIsInput = targetIsParentComponentPort ? targetPort instanceof OutputPort : targetPort instanceof InputPort;
        return sourceIsOutput == targetIsInput;
    }

    private Component getConnectionContainer(Port p1, Port p2) {
        Component parent1 = p1.getComponent();
        Component parent2 = p2.getComponent();
        Component gParent1 = ComponentUtils.componentOf(parent1.eContainer());
        if (gParent1 == null) {
            return parent1;
        }
        return gParent1.equals(parent2) ? gParent1 : parent2.getParentComponent();
    }

    protected IConnection createConnection() {
        return ComponentModelElementFactory.createChannel();
    }

    public boolean canDisconnect(EObject connection) {
        return connection instanceof Channel;
    }
}

