/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.consistency;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.fortiss.af3.component.consistency.ConnectorConsistencyProviderUtils;
import org.fortiss.af3.consistency.provider.AF3ConsistencyProviderBase;
import org.fortiss.consistency.model.views.ClassFeature;
import org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsFactory;
import org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsPackage;
import org.fortiss.consistency.viewtypes.architectureElements.Connector;
import org.fortiss.consistency.viewtypes.architectureElements.InputConnector;
import org.fortiss.consistency.viewtypes.architectureElements.OutputConnector;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProviderService;

public class ConnectorConsistencyProvider
extends AF3ConsistencyProviderBase<IConnector> {
    public Class<?> getClassOfCorrespondingConsistencyViewtypeElement() {
        return Connector.class;
    }

    public EObject transformIntoConsistencyViewtypeElement(IConnector element, EMap<String, EList<ClassFeature>> featuresPerClass) {
        return ConnectorConsistencyProvider.transformConnector(element, new HashMap<IConnector, Connector>(), featuresPerClass);
    }

    private static EObject transformConnector(IConnector sourceElement, HashMap<IConnector, Connector> alreadyTransformedConnectors, EMap<String, EList<ClassFeature>> featuresPerClass) {
        Connector transformedElement = ArchitectureElementsFactory.eINSTANCE.createConnector();
        IConsistencyProviderService consistencyService = IConsistencyProviderService.getInstance();
        Class elementClass = consistencyService.getClassOfCorrespondingConsistencyViewtypeElement((EObject)sourceElement);
        List neededFeatureNames = ConnectorConsistencyProvider.getFeatureNamesForClass(featuresPerClass, (Class)elementClass);
        ConnectorConsistencyProviderUtils.transformBasicConnectorInfo(sourceElement, transformedElement, featuresPerClass);
        alreadyTransformedConnectors.put(sourceElement, transformedElement);
        EReference currentFeature = ArchitectureElementsPackage.Literals.CONNECTOR__CONNECTED_CONNECTORS;
        if (neededFeatureNames.contains(currentFeature.getName())) {
            EList connectedConnectors = transformedElement.getConnectedConnectors();
            if (sourceElement instanceof ExitConnectorBase) {
                List<InputConnector> connectedInputs = ConnectorConsistencyProviderUtils.getAllConnectedInputs((ExitConnectorBase)sourceElement, alreadyTransformedConnectors, featuresPerClass);
                connectedConnectors.addAll(connectedInputs);
            }
            if (sourceElement instanceof EntryConnectorBase) {
                List<OutputConnector> connectedOutputs = ConnectorConsistencyProviderUtils.getAllConnectedOutputs((EntryConnectorBase)sourceElement, alreadyTransformedConnectors, featuresPerClass);
                connectedConnectors.addAll(connectedOutputs);
            }
        }
        return transformedElement;
    }
}

