/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.consistency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.consistency.EntryConnectorBaseConsistencyProvider;
import org.fortiss.af3.component.consistency.ExitConnectorBaseConsistencyProvider;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.expression.model.terms.BoolConst;
import org.fortiss.af3.expression.model.terms.DoubleConst;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.consistency.model.views.ClassFeature;
import org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsPackage;
import org.fortiss.consistency.viewtypes.architectureElements.Connector;
import org.fortiss.consistency.viewtypes.architectureElements.InputConnector;
import org.fortiss.consistency.viewtypes.architectureElements.OutputConnector;
import org.fortiss.consistency.viewtypes.basics.BasicsPackage;
import org.fortiss.consistency.viewtypes.types.IValue;
import org.fortiss.consistency.viewtypes.types.NoValue;
import org.fortiss.consistency.viewtypes.types.TypeInteger;
import org.fortiss.consistency.viewtypes.types.TypesFactory;
import org.fortiss.consistency.viewtypes.types.ValueBoolean;
import org.fortiss.consistency.viewtypes.types.ValueDouble;
import org.fortiss.consistency.viewtypes.types.ValueInteger;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.ext.consistency.service.FortissToolingKernelConsistencyProviderBase;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProviderService;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ConnectorConsistencyProviderUtils {
    protected static void transformBasicConnectorInfo(IConnector sourceConnector, Connector targetConnector, EMap<String, EList<ClassFeature>> featuresPerClass) {
        EAttribute currentFeature;
        IConsistencyProviderService consistencyService = IConsistencyProviderService.getInstance();
        Class elementClass = consistencyService.getClassOfCorrespondingConsistencyViewtypeElement((EObject)sourceConnector);
        List neededFeatureNames = FortissToolingKernelConsistencyProviderBase.getFeatureNamesForClass(featuresPerClass, (Class)elementClass);
        if (neededFeatureNames.contains((currentFeature = BasicsPackage.Literals.INAMED_ELEMENT__NAME).getName()) && sourceConnector instanceof INamedElement) {
            String name = ((INamedElement)sourceConnector).getName();
            targetConnector.setName(name);
        }
        if (neededFeatureNames.contains((currentFeature = BasicsPackage.Literals.INAMED_COMMENTED_ELEMENT__COMMENT).getName()) && sourceConnector instanceof INamedCommentedElement) {
            targetConnector.setComment(((INamedCommentedElement)sourceConnector).getComment());
        }
        EList specs = sourceConnector.getSpecifications();
        EList portSpec = EcoreUtils.pickInstanceOf(PortSpecification.class, (List)specs);
        TypeInteger transformedType = null;
        NoValue transformedValue = null;
        if (portSpec != null && !portSpec.isEmpty()) {
            currentFeature = ArchitectureElementsPackage.Literals.CONNECTOR__TYPE;
            if (neededFeatureNames.contains(currentFeature.getName())) {
                IType af3Type = ((PortSpecification)portSpec.iterator().next()).getType();
                if (af3Type instanceof TInt) {
                    transformedType = TypesFactory.eINSTANCE.createTypeInteger();
                } else if (af3Type instanceof TDouble) {
                    transformedType = TypesFactory.eINSTANCE.createTypeDouble();
                } else if (af3Type instanceof TBool) {
                    transformedType = TypesFactory.eINSTANCE.createTypeBoolean();
                }
                targetConnector.setType((org.fortiss.consistency.viewtypes.types.IType)transformedType);
            }
            if (neededFeatureNames.contains((currentFeature = ArchitectureElementsPackage.Literals.CONNECTOR__DEFAULT_VALUE).getName())) {
                IExpressionTerm af3Term = ((PortSpecification)portSpec.iterator().next()).getInitialValue();
                if (af3Term instanceof IntConst) {
                    ValueInteger intValue = TypesFactory.eINSTANCE.createValueInteger();
                    int af3IntValue = ((IntConst)af3Term).getValue();
                    intValue.setValue(af3IntValue);
                    transformedValue = intValue;
                } else if (af3Term instanceof DoubleConst) {
                    ValueDouble doubleValue = TypesFactory.eINSTANCE.createValueDouble();
                    double af3DoubleValue = ((DoubleConst)af3Term).getValue();
                    doubleValue.setValue(af3DoubleValue);
                    transformedValue = doubleValue;
                } else if (af3Term instanceof BoolConst) {
                    ValueBoolean booleanValue = TypesFactory.eINSTANCE.createValueBoolean();
                    boolean af3booleanValue = ((BoolConst)af3Term).getValue();
                    booleanValue.setValue(af3booleanValue);
                    transformedValue = booleanValue;
                } else {
                    transformedValue = TypesFactory.eINSTANCE.createNoValue();
                }
                targetConnector.setDefaultValue((IValue)transformedValue);
            }
        }
    }

    protected static List<OutputConnector> getAllConnectedOutputs(EntryConnectorBase sourceElement, HashMap<IConnector, Connector> alreadyTransformedConnectors, EMap<String, EList<ClassFeature>> featuresPerClass) {
        ArrayList<OutputConnector> connectedOutputs = new ArrayList<OutputConnector>();
        EList incomingConnections = sourceElement.getIncoming();
        for (IConnection incomingConnection : incomingConnections) {
            OutputConnector transformedObject;
            Connector alreadyTransformedConnector;
            IConnector sourceConnector = incomingConnection.getSource();
            if (!(sourceConnector instanceof ExitConnectorBase)) continue;
            ExitConnectorBase sourceConnectorBase = (ExitConnectorBase)sourceConnector;
            OutputConnector transformedSource = null;
            if (alreadyTransformedConnectors.containsKey(sourceConnector) && (alreadyTransformedConnector = alreadyTransformedConnectors.get(sourceConnector)) instanceof OutputConnector) {
                transformedSource = (OutputConnector)alreadyTransformedConnector;
            }
            if (transformedSource == null && (transformedObject = ExitConnectorBaseConsistencyProvider.transformOutputConnector(sourceConnectorBase, alreadyTransformedConnectors, featuresPerClass)) instanceof OutputConnector) {
                transformedSource = transformedObject;
            }
            connectedOutputs.add(transformedSource);
        }
        return connectedOutputs;
    }

    protected static List<InputConnector> getAllConnectedInputs(ExitConnectorBase sourceElement, HashMap<IConnector, Connector> alreadyTransformedConnectors, EMap<String, EList<ClassFeature>> featuresPerClass) {
        ArrayList<InputConnector> connectedInputs = new ArrayList<InputConnector>();
        EList outgoingConnections = sourceElement.getOutgoing();
        for (IConnection outgoingConnection : outgoingConnections) {
            EObject transformedObject;
            Connector alreadyTransformedConnector;
            IConnector targetConnector = outgoingConnection.getTarget();
            if (!(targetConnector instanceof EntryConnectorBase)) continue;
            EntryConnectorBase targetConnectorBase = (EntryConnectorBase)targetConnector;
            InputConnector transformedTarget = null;
            if (alreadyTransformedConnectors.containsKey(targetConnector) && (alreadyTransformedConnector = alreadyTransformedConnectors.get(targetConnector)) instanceof InputConnector) {
                transformedTarget = (InputConnector)alreadyTransformedConnector;
            }
            if (transformedTarget == null && (transformedObject = EntryConnectorBaseConsistencyProvider.transformInputConnector(targetConnectorBase, alreadyTransformedConnectors, featuresPerClass)) instanceof InputConnector) {
                transformedTarget = (InputConnector)transformedObject;
            }
            connectedInputs.add(transformedTarget);
        }
        return connectedInputs;
    }
}

