/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.constraint;

import java.util.List;
import org.fortiss.af3.component.constraint.ConstraintMessage;
import org.fortiss.af3.component.constraint.RetargetTypeCheckConstraintCheckerBase;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.ComplexVar;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.utils.VariableScopeUtils;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.model.INamedElement;

public abstract class ActionConstraintCheckerBase<T extends INamedElement>
extends RetargetTypeCheckConstraintCheckerBase<Action, T> {
    public boolean isApplicable(Action modelElement) {
        return modelElement != null && modelElement.getVariable() != null && modelElement.getValue() != null;
    }

    @Override
    protected IConstraintViolation<T> createUnknownTypeViolation(Action modelElement) {
        return ConstraintMessage.createUnknownTypeViolationWithSource(modelElement, this.getSource(modelElement), this.getContainer(modelElement));
    }

    @Override
    protected IConstraintViolation<T> createMismatchViolation(Action modelElement, String detailedMessage) {
        return ConstraintMessage.createActionTypeMismatchViolation(modelElement, this.getSource(modelElement), this.getContainer(modelElement), detailedMessage);
    }

    @Override
    protected ITerm getTermToCheck(Action modelElement) {
        return modelElement.getValue();
    }

    @Override
    protected IType getTargetType(Action modelElement) {
        return VariableScopeUtils.getVarType((VarBase)modelElement.getVariable());
    }

    @Override
    protected IConstraintViolation<T> createUnknownIdentifierViolation(Action modelElement, Var v) {
        return ConstraintMessage.createUnknownIdentifierInComponentViolation(modelElement.toString(), v, this.getSource(modelElement), this.getContainer(modelElement));
    }

    @Override
    protected void collectOtherViolations(Action action, List<IConstraintViolation<T>> results) {
        Var var = action.getVariable();
        IVariableDefinition lhs = VariableScopeUtils.getVarDefinition((VarBase)var);
        if (var instanceof ComplexVar && lhs instanceof OutputPort) {
            results.add(ConstraintMessage.createActionLHSComplexAccessViolation(action, this.getSource(action), this.getContainer(action)));
        }
        if (lhs == null) {
            results.add(this.createUnknownIdentifierViolation(action, var));
        }
        if (lhs instanceof InputPort) {
            results.add(ConstraintMessage.createActionLHSViolation(action, this.getSource(action), this.getContainer(action)));
        }
        if (lhs instanceof DataStateVariable && NoVal.isNoValConst((ITerm)action.getValue())) {
            results.add(this.createNoValViolation(action));
        }
    }
}

