/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.constraint;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.constraint.ConstraintMessage;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.expression.language.TypeCheckStatus;
import org.fortiss.af3.expression.language.TypeSystemHandler;
import org.fortiss.tooling.kernel.extension.base.MultiViolationConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class ChannelConstraintChecker
extends MultiViolationConstraintCheckerBase<Channel, Channel> {
    public boolean isApplicable(Channel modelElement) {
        return modelElement != null && modelElement.getSource() != null && modelElement.getTarget() != null;
    }

    public void collectViolations(Channel channel, List<IConstraintViolation<Channel>> results) {
        PortSpecification sourceSpec = channel.getSource().getPortSpecification();
        PortSpecification targetSpec = channel.getTarget().getPortSpecification();
        TypeCheckStatus portTypecheck = TypeSystemHandler.INSTANCE.getTypeChecker().typecheck(sourceSpec.getType(), targetSpec.getType(), (EObject)channel);
        if (!portTypecheck.isOK()) {
            results.add(ConstraintMessage.createChannelTypeMismatchViolation(channel, channel.getName(), portTypecheck.getMessage()));
        }
    }
}

