/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.constraint;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.constraint.ConstraintMessage;
import org.fortiss.af3.component.constraint.TypeCheckConstraintCheckerBase;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.behavior.code.CodeSpecification;
import org.fortiss.af3.expression.model.terms.ComplexVar;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.types.impl.TBoolStaticImpl;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class CodeSpecificationConstraintChecker
extends TypeCheckConstraintCheckerBase<CodeSpecification, Component> {
    public boolean isApplicable(CodeSpecification modelElement) {
        return modelElement != null && modelElement.getBody() != null;
    }

    @Override
    protected IConstraintViolation<Component> createMismatchViolation(CodeSpecification modelElement, String detailedMessage) {
        return ConstraintMessage.createCodeSpecificationTypeMismatchViolation(modelElement, modelElement.getComponent(), detailedMessage);
    }

    @Override
    protected IConstraintViolation<Component> createIllegalAssignmentVariableViolation(CodeSpecification modelElement, Assignment assign) {
        return ConstraintMessage.createIllegalAssignmentViolation(assign, modelElement, modelElement.getComponent());
    }

    @Override
    protected IConstraintViolation<Component> createNoValViolation(CodeSpecification modelElement) {
        return ConstraintMessage.createInvalidUseOfNoVal(modelElement.getComponent(), (EObject)modelElement.getComponent());
    }

    @Override
    protected IConstraintViolation<Component> createIllegalUseOfOutputPortViolation(CodeSpecification modelElement, Var var) {
        return ConstraintMessage.createIllegalUseOfOutputPortViolation(var.eContainer().toString(), var, modelElement.getComponent(), (EObject)modelElement.getComponent());
    }

    @Override
    protected ITerm getTermToCheck(CodeSpecification modelElement) {
        return modelElement.getBody();
    }

    @Override
    protected IType getTargetType(CodeSpecification modelElement) {
        return TBoolStaticImpl.INSTANCE;
    }

    @Override
    protected IConstraintViolation<Component> createUnknownIdentifierViolation(CodeSpecification modelElement, Var v) {
        Component c = this.findParent(modelElement.eContainer());
        return ConstraintMessage.createUnknownIdentifierInComponentViolation("code specification", v, c, (EObject)modelElement);
    }

    @Override
    protected void collectOtherViolations(CodeSpecification modelElement, List<IConstraintViolation<Component>> results) {
        if (modelElement.getBody().getStatements().isEmpty()) {
            results.add(ConstraintMessage.createCodeSpecificationTypeMismatchViolation(modelElement, modelElement.getComponent(), "The code specification cannot be parsed correctly."));
        }
        for (Assignment as : EcoreUtils.getChildrenWithType((EObject)modelElement, Assignment.class)) {
            ComplexVar cv;
            IVariableDefinition varDef;
            Var var = as.getVariable();
            if (!(var instanceof ComplexVar) || !((varDef = (cv = (ComplexVar)var).getVarDefinition((EObject)modelElement)) instanceof OutputPort)) continue;
            results.add(ConstraintMessage.createAssignmentLHSComplexAccessViolation(as, modelElement.getComponent(), (EObject)modelElement));
        }
    }
}

