/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.constraint;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.constraint.ConstraintMessage;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.expression.language.TypeCheckStatus;
import org.fortiss.af3.expression.language.TypeSystemHandler;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.utils.TypeScopeUtils;
import org.fortiss.tooling.kernel.extension.base.MultiViolationConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.IdentifierUtils;

public class ComponentConstraintChecker
extends MultiViolationConstraintCheckerBase<Component, Component> {
    public void collectViolations(Component modelElement, List<IConstraintViolation<Component>> results) {
        this.performStartsWithNumberNameCheck((INamedElement)modelElement, results);
        HashSet<String> seenPorts = new HashSet<String>();
        for (Port p : modelElement.getInputPorts()) {
            this.performPortCheck(p, seenPorts, results);
        }
        for (Port p : modelElement.getOutputPorts()) {
            this.performPortCheck(p, seenPorts, results);
        }
    }

    private void performStartsWithNumberNameCheck(INamedElement modelElement, List<IConstraintViolation<Component>> results) {
        String name = modelElement.getName();
        if ("".equals(name) || Character.isDigit(name.charAt(0)) || IdentifierUtils.containsDisallowedCharactersInName((INamedElement)modelElement)) {
            if (modelElement instanceof Component) {
                results.add((IConstraintViolation<Component>)ConstraintMessage.createIllegalNameViolation((Component)modelElement, name));
            } else if (modelElement instanceof Port) {
                results.add((IConstraintViolation<Component>)ConstraintMessage.createIllegalNameViolation((Port)modelElement, name));
            }
        }
    }

    private void performPortCheck(Port p, Set<String> seenPorts, List<IConstraintViolation<Component>> results) {
        if (seenPorts.contains(p.getName())) {
            results.add((IConstraintViolation<Component>)ConstraintMessage.createDuplicatePortViolation(p.getComponent(), p.getName()));
        } else {
            seenPorts.add(p.getName());
            this.performStartsWithNumberNameCheck((INamedElement)p, results);
            this.performTypeCheck(p, results);
        }
    }

    private void performTypeCheck(Port p, List<IConstraintViolation<Component>> results) {
        TypeCheckStatus typecheckRes;
        int num = results.size();
        PortSpecification spec = p.getPortSpecification();
        Component comp = p.getComponent();
        if (spec.getType() instanceof TDefinedType && TypeScopeUtils.getTypeDefinition((IType)spec.getType(), (EObject)p) == null) {
            results.add(ConstraintMessage.createUnknownTypeViolationWithSource(comp, "port", p.getName()));
        }
        if (num == results.size() && !(typecheckRes = TypeSystemHandler.INSTANCE.getTypeChecker().typecheck((ITerm)spec.getInitialValue(), spec.getType(), (EObject)p)).isOK()) {
            results.add(ConstraintMessage.createInitialValueTypeMismatchViolation(comp, "port", p.getName(), typecheckRes.getMessage()));
        }
    }
}

