/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.constraint;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.code.CodeSpecification;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.tooling.kernel.extension.base.ConstraintViolationBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.model.INamedElement;

final class ConstraintMessage {
    ConstraintMessage() {
    }

    public static ConstraintViolationBase<Component> createWeaklyCausalCycleViolation(Component c) {
        String msg = "Component " + c.getName();
        msg = msg + " is part of a weakly causal cycle.\n";
        msg = msg + "Possible fix: make one of the components in the cycle strongly causal (but take ";
        msg = msg + "care: this will introduce a delay in the behavior) or add a strongly causal ";
        msg = msg + "component to explicitly introduce a delay in the feedback loop.";
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, msg);
    }

    public static ConstraintViolationBase<Component> createDuplicatePortViolation(Component c, String name) {
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, "Duplicate port or data state variable name " + name + " in " + c.getName());
    }

    public static ConstraintViolationBase<Component> createIllegalNameViolation(Component c, String name) {
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, "Illegal component name " + name);
    }

    public static ConstraintViolationBase<Component> createIllegalNameViolation(Port p, String name) {
        return new ConstraintViolationBase((EObject)p.getComponent(), IConstraintViolation.ESeverity.ERROR, "Illegal port name " + name + " in component " + p.getComponent().getName());
    }

    public static IConstraintViolation<Component> createUnknownTypeViolationWithSource(Component c, String source, String name) {
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, "Type of " + source + " " + name + " in component " + c.getName() + " is unknown");
    }

    public static <T extends INamedElement> IConstraintViolation<T> createUnknownTypeViolationWithSource(Action a, T source, EObject container) {
        return new ConstraintViolationBase(source, IConstraintViolation.ESeverity.ERROR, "Some type is unknown in action " + a.toString() + " of " + source.getName(), container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createInvalidUseOfNoVal(T source, EObject container) {
        return new ConstraintViolationBase(source, IConstraintViolation.ESeverity.ERROR, "Invalid use of NoVal.", container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createUnknownTypeViolationWithSource(DataStateVariable dsv, T source, EObject container) {
        return new ConstraintViolationBase(source, IConstraintViolation.ESeverity.ERROR, "Type of data state variable " + dsv.getIdentifier() + " in " + source.getName() + " is unknown", container);
    }

    public static IConstraintViolation<Component> createInitialValueTypeMismatchViolation(Component c, String source, String name, String detailedMessage) {
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, "Type mismatch in initial value of " + source + " " + name + " in component " + c.getName() + ":\n" + detailedMessage);
    }

    public static IConstraintViolation<Component> createInitialValueTypeMismatchViolation(Component c, String source, String name) {
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, "Type mismatch in initial value of " + source + " " + name + " in component " + c.getName());
    }

    private static String within(String s) {
        return s == "" ? "" : " within " + s;
    }

    public static <T extends INamedElement> IConstraintViolation<T> createInitialValueTypeMismatchViolation(DataStateVariable dsv, T source, EObject container, String detailedMessage) {
        return new ConstraintViolationBase(source, IConstraintViolation.ESeverity.ERROR, "Type mismatch in initial value of data state variable " + dsv.getIdentifier() + ConstraintMessage.within(source.getName()) + ":\n" + detailedMessage, container);
    }

    public static IConstraintViolation<Component> createCodeSpecificationTypeMismatchViolation(CodeSpecification spec, Component c, String detailedMessage) {
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, "Type mismatch in code specification of component " + c.getName() + ":\n" + detailedMessage, (EObject)spec);
    }

    public static IConstraintViolation<Component> createIllegalAssignmentViolation(Assignment assign, CodeSpecification spec, Component c) {
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, "Illegal assignment to variable \"" + assign.toString() + "\"in code specification of component " + c.getName(), (EObject)spec);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createActionTypeMismatchViolation(Action a, T source, EObject container, String detailedMessage) {
        return new ConstraintViolationBase(source, IConstraintViolation.ESeverity.ERROR, "Type mismatch in action " + a.toString() + ConstraintMessage.within(source.getName()) + ":\n" + detailedMessage, container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createActionLHSViolation(Action a, T source, EObject container) {
        return new ConstraintViolationBase(source, IConstraintViolation.ESeverity.ERROR, "Wrong action " + a.toString() + ConstraintMessage.within(source.getName()) + "! Input port cannot be left-hand-side of an assignment.", container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createActionLHSComplexAccessViolation(Action a, T source, EObject container) {
        return new ConstraintViolationBase(source, IConstraintViolation.ESeverity.ERROR, "Wrong action " + a.toString() + ConstraintMessage.within(source.getName()) + "! Members of output ports arrays or structs cannot be assigned individually.", container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createAssignmentLHSComplexAccessViolation(Assignment a, T source, EObject container) {
        return new ConstraintViolationBase(source, IConstraintViolation.ESeverity.ERROR, "Wrong assignment " + a.toString() + ConstraintMessage.within(source.getName()) + "! Members of output ports arrays or structs cannot be assigned individually.", container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createGuardTypeMismatchViolation(Guard g, T source, EObject container, String detailedMessage) {
        return new ConstraintViolationBase(source, IConstraintViolation.ESeverity.ERROR, "Type mismatch in guard " + g.toString() + ConstraintMessage.within(source.getName()) + ":\n" + detailedMessage, container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createUnknownIdentifierInDSVViolation(DataStateVariable dsv, Var var, T sourceElement, EObject container) {
        return new ConstraintViolationBase(sourceElement, IConstraintViolation.ESeverity.ERROR, "Unknown identifier " + var.getIdentifier() + " in data state variable " + dsv.getIdentifier() + ConstraintMessage.within(sourceElement.getName()), container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createUnknownIdentifierInGuardViolation(Guard g, Var var, T sourceElement, EObject container) {
        return new ConstraintViolationBase(sourceElement, IConstraintViolation.ESeverity.ERROR, "Unknown identifier " + var.getIdentifier() + " in guard " + g.toString() + ConstraintMessage.within(sourceElement.getName()), container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createUnknownIdentifierInComponentViolation(String source, Var var, T sourceElement, EObject container) {
        return new ConstraintViolationBase(sourceElement, IConstraintViolation.ESeverity.ERROR, "Unknown identifier " + var.getIdentifier() + " in " + source + ConstraintMessage.within(sourceElement.getName()), container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createIllegalUseOfOutputPortViolation(String source, Var var, T sourceElement, EObject container) {
        return new ConstraintViolationBase(sourceElement, IConstraintViolation.ESeverity.ERROR, "Illegal use of output port identifier " + var.getIdentifier() + " in " + source + ConstraintMessage.within(sourceElement.getName()), container);
    }

    public static IConstraintViolation<Channel> createChannelTypeMismatchViolation(Channel c, String name, String detailedMessage) {
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, "Type mismatch in channel " + name + " of component " + c.getName() + ":\n" + detailedMessage, (EObject)c.getParentComponent());
    }

    public static IConstraintViolation<Channel> createChannelInitialValueMismatchViolation(Channel c, String name) {
        return new ConstraintViolationBase((EObject)c, IConstraintViolation.ESeverity.ERROR, "Initial value mismatch in channel " + name + " of component " + c.getName(), (EObject)c.getParentComponent());
    }

    public static <T extends INamedElement> IConstraintViolation<T> createIllegalUseOfInputPortViolation(String source, Var var, T sourceElement, EObject container) {
        return new ConstraintViolationBase(sourceElement, IConstraintViolation.ESeverity.ERROR, "Illegal use of input port identifier " + var.getIdentifier() + " in " + source + ConstraintMessage.within(sourceElement.getName()), container);
    }

    public static <T extends INamedElement> IConstraintViolation<T> createDuplicateDataStateVariableViolation(T sourceElement, String name) {
        return new ConstraintViolationBase(sourceElement, IConstraintViolation.ESeverity.ERROR, "Duplicate port or data state variable name " + name + " in the component" + sourceElement.getName());
    }
}

