/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.constraint.ConstraintMessage;
import org.fortiss.af3.component.constraint.RetargetTypeCheckConstraintCheckerBase;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.IDataStateVariableProvider;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.utils.VariableScopeUtils;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public abstract class DataStateVariableConstraintCheckerBase<T extends INamedElement>
extends RetargetTypeCheckConstraintCheckerBase<DataStateVariable, T> {
    public boolean isApplicable(DataStateVariable modelElement) {
        return modelElement != null && modelElement.getVar() != null && modelElement.getType() != null && modelElement.getInitialValue() != null;
    }

    @Override
    protected IConstraintViolation<T> createUnknownTypeViolation(DataStateVariable modelElement) {
        return ConstraintMessage.createUnknownTypeViolationWithSource(modelElement, this.getSource(modelElement), this.getContainer(modelElement));
    }

    @Override
    protected IConstraintViolation<T> createMismatchViolation(DataStateVariable modelElement, String detailedMessage) {
        return ConstraintMessage.createInitialValueTypeMismatchViolation(modelElement, this.getSource(modelElement), this.getContainer(modelElement), detailedMessage);
    }

    @Override
    protected ITerm getTermToCheck(DataStateVariable modelElement) {
        return modelElement.getInitialValue();
    }

    @Override
    protected IType getTargetType(DataStateVariable modelElement) {
        return modelElement.getType();
    }

    @Override
    protected IConstraintViolation<T> createUnknownIdentifierViolation(DataStateVariable modelElement, Var v) {
        return ConstraintMessage.createUnknownIdentifierInDSVViolation(modelElement, v, this.getSource(modelElement), this.getContainer(modelElement));
    }

    @Override
    protected void collectOtherViolations(DataStateVariable modelElement, List<IConstraintViolation<T>> results) {
        this.checkDuplicateNames(modelElement, results);
        IExpressionTerm initVal = modelElement.getInitialValue();
        if (initVal instanceof Var && VariableScopeUtils.getVarDefinition((VarBase)((Var)initVal)) instanceof InputPort) {
            results.add(ConstraintMessage.createIllegalUseOfInputPortViolation(modelElement.toString(), (Var)initVal, this.getSource(modelElement), this.getContainer(modelElement)));
        }
    }

    private void checkDuplicateNames(DataStateVariable dsv, List<IConstraintViolation<T>> results) {
        IDataStateVariableProvider dsvProvider = (IDataStateVariableProvider)EcoreUtils.getFirstParentWithType((EObject)dsv, IDataStateVariableProvider.class);
        ArrayList<Port> vds = new ArrayList<Port>();
        vds.addAll(LambdaUtils.filterList(dsvProvider.getDataStateVariables(), x -> x != dsv));
        Component comp = (Component)EcoreUtils.getFirstParentWithType((EObject)dsv, Component.class);
        vds.addAll((Collection<Port>)comp.getInputPorts());
        vds.addAll((Collection<Port>)comp.getOutputPorts());
        for (IVariableDefinition iVariableDefinition : vds) {
            if (!dsv.getIdentifier().equals(iVariableDefinition.getVar().getIdentifier())) continue;
            results.add(ConstraintMessage.createDuplicateDataStateVariableViolation(this.getSource(dsv), dsv.getIdentifier()));
        }
    }
}

