/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.constraint;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.expression.language.TypeCheckStatus;
import org.fortiss.af3.expression.language.TypeSystemHandler;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.terms.ComplexVar;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.impl.DefinedConstStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.expression.utils.NoValSpecialTreatmentUtils;
import org.fortiss.af3.project.model.typesystem.IFunction;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.utils.TypeScopeUtils;
import org.fortiss.af3.project.utils.VariableScopeUtils;
import org.fortiss.tooling.kernel.extension.base.MultiViolationConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

abstract class TypeCheckConstraintCheckerBase<T extends EObject, V extends EObject>
extends MultiViolationConstraintCheckerBase<T, V> {
    TypeCheckConstraintCheckerBase() {
    }

    protected final void collectViolations(T modelElement, List<IConstraintViolation<V>> results) {
        TypeCheckStatus typecheckRes;
        this.collectOtherViolations(modelElement, results);
        ITerm term = this.getTermToCheck(modelElement);
        if (term instanceof Var) {
            this.doIdentifierCheck((Var)term, modelElement, results);
        }
        TreeIterator iter = term.eAllContents();
        while (iter.hasNext()) {
            EObject eo = (EObject)iter.next();
            if (eo instanceof Var) {
                this.doIdentifierCheck((Var)eo, modelElement, results);
                continue;
            }
            if (eo.equals(DefinedConstStaticImpl.NoVal)) {
                this.doNoValCheck(modelElement, eo, results);
                continue;
            }
            if (!(eo instanceof Assignment)) continue;
            this.doAssignmentCheck(modelElement, (Assignment)eo, results);
        }
        if (this.getTargetType(modelElement) == null) {
            return;
        }
        if (this.getTargetType(modelElement) instanceof TDefinedType && TypeScopeUtils.getTypeDefinition((IType)this.getTargetType(modelElement), modelElement) == null) {
            results.add(this.createUnknownTypeViolation(modelElement));
        }
        if (!(typecheckRes = TypeSystemHandler.INSTANCE.getTypeChecker().typecheck(term, this.getTargetType(modelElement), modelElement)).isOK()) {
            results.add(this.createMismatchViolation(modelElement, typecheckRes.getMessage()));
        }
    }

    private void doAssignmentCheck(T modelElement, Assignment assign, List<IConstraintViolation<V>> results) {
        IVariableDefinition vdef = VariableScopeUtils.getVarDefinition((VarBase)assign.getVariable());
        if (vdef instanceof InputPort) {
            results.add(this.createIllegalAssignmentVariableViolation(modelElement, assign));
        }
        if (!(vdef instanceof OutputPort) && DefinedConstStaticImpl.NoVal.equals((Object)assign.getValue())) {
            results.add(this.createNoValViolation(modelElement));
        }
    }

    private void doIdentifierCheck(Var var, T modelElement, List<IConstraintViolation<V>> results) {
        StructureMember structMember;
        IExpressionTerm struct;
        IType type;
        ITypeDefinition typedef;
        FunctionCall funcall;
        if (var instanceof ComplexVar) {
            return;
        }
        if (var.eContainer() instanceof ITerm && ExpressionUtils.isStructureAccess((ITerm)((ITerm)var.eContainer())) && (funcall = (FunctionCall)var.eContainer()).getArguments().get(1) == var && (typedef = TypeScopeUtils.getTypeDefinition((IType)(type = VariableScopeUtils.getVarType((VarBase)VarStaticImpl.create((IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)(struct = (IExpressionTerm)funcall.getArguments().get(0))))), (EObject)var)), (EObject)var)) instanceof Structure && (structMember = ExpressionUtils.getStructureMember((Structure)((Structure)typedef), (String)var.getIdentifier())) != null) {
            return;
        }
        IVariableDefinition def = VariableScopeUtils.getVarDefinition((VarBase)var);
        if (def == null) {
            results.add(this.createUnknownIdentifierViolation(modelElement, var));
        } else if (def instanceof OutputPort && (!(var.eContainer() instanceof Assignment) || ((Assignment)var.eContainer()).getVariable() != var)) {
            results.add(this.createIllegalUseOfOutputPortViolation(modelElement, var));
        }
    }

    private void doNoValCheck(T modelElement, EObject noValRef, List<IConstraintViolation<V>> results) {
        EObject cont = noValRef.eContainer();
        if (cont instanceof FunctionCall) {
            FunctionCall fc = (FunctionCall)cont;
            IFunction fun = fc.getFunction();
            if (!(fun instanceof PredefinedFunction)) {
                results.add(this.createNoValViolation(modelElement));
            } else if (!NoValSpecialTreatmentUtils.isEqualityOrInequalityWithNoVal((FunctionCall)fc)) {
                results.add(this.createNoValViolation(modelElement));
            } else {
                Var var = NoValSpecialTreatmentUtils.getVariableAccessedInEqualityOrInequalityWithNoVal((FunctionCall)fc);
                IVariableDefinition varDef = VariableScopeUtils.getVarDefinition((VarBase)var);
                if (varDef == null) {
                    return;
                }
                if (!(varDef instanceof Port)) {
                    results.add(this.createNoValViolation(modelElement));
                }
            }
        }
    }

    protected void collectOtherViolations(T modelElement, List<IConstraintViolation<V>> results) {
    }

    protected IConstraintViolation<V> createUnknownTypeViolation(T modelElement) {
        return null;
    }

    protected IConstraintViolation<V> createIllegalAssignmentVariableViolation(T modelElement, Assignment assign) {
        return null;
    }

    protected IConstraintViolation<V> createIllegalUseOfOutputPortViolation(T modelElement, Var var) {
        return null;
    }

    protected abstract IConstraintViolation<V> createMismatchViolation(T var1, String var2);

    protected abstract IConstraintViolation<V> createUnknownIdentifierViolation(T var1, Var var2);

    protected abstract IConstraintViolation<V> createNoValViolation(T var1);

    protected abstract ITerm getTermToCheck(T var1);

    protected abstract IType getTargetType(T var1);

    protected final Component findParent(EObject eo) {
        while (eo != null && !(eo instanceof Component)) {
            eo = eo.eContainer();
        }
        return (Component)eo;
    }

    protected boolean isNoValAllowed() {
        return true;
    }
}

