/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.constraint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.component.constraint.ConstraintMessage;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.tooling.kernel.extension.base.MultiViolationConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class WeakCausalityCycleConstraintChecker
extends MultiViolationConstraintCheckerBase<ComponentArchitecture, Component> {
    public void collectViolations(ComponentArchitecture modelElement, List<IConstraintViolation<Component>> results) {
        EList<Component> weaklyCausal = ((Component)modelElement.getContainedElements().get(0)).findWeaklyCausalComponents();
        HashMap<Component, Set<Component>> predMap = new HashMap<Component, Set<Component>>();
        this.fillPredecessorMap((Map<Component, Set<Component>>)predMap, (List<Component>)weaklyCausal);
        for (Component candidate : weaklyCausal) {
            this.doCycleSearch(candidate, predMap, results);
        }
    }

    private void doCycleSearch(Component candidate, Map<Component, Set<Component>> predMap, List<IConstraintViolation<Component>> results) {
        if (predMap.get(candidate).contains(candidate)) {
            results.add((IConstraintViolation<Component>)ConstraintMessage.createWeaklyCausalCycleViolation(candidate));
        }
        HashSet<Component> seenComps = new HashSet<Component>();
        for (Component next : predMap.get(candidate)) {
            seenComps.clear();
            if (!predMap.containsKey(next) || !this.findInPredecessorMap(predMap, next, candidate, seenComps)) continue;
            results.add((IConstraintViolation<Component>)ConstraintMessage.createWeaklyCausalCycleViolation(candidate));
            return;
        }
    }

    private boolean findInPredecessorMap(Map<Component, Set<Component>> predMap, Component next, Component candidate, Set<Component> seenComps) {
        if (predMap.get(next).contains(candidate)) {
            return true;
        }
        for (Component nextNext : predMap.get(next)) {
            if (!predMap.containsKey(nextNext) || seenComps.contains(nextNext)) continue;
            seenComps.add(nextNext);
            if (this.findInPredecessorMap(predMap, nextNext, candidate, seenComps)) {
                return true;
            }
            seenComps.remove(nextNext);
        }
        return false;
    }

    private void fillPredecessorMap(Map<Component, Set<Component>> predMap, List<Component> weaklyCausal) {
        for (Component c : weaklyCausal) {
            HashSet<Component> predSet = new HashSet<Component>();
            predMap.put(c, predSet);
            for (InputPort inport : c.getInputPorts()) {
                Component source = this.findNonEnvironmentAtomicDataSource(inport);
                if (source == null) continue;
                predSet.add(source);
            }
        }
    }

    private Component findNonEnvironmentAtomicDataSource(InputPort inport) {
        Port p = inport;
        while (!p.getIncoming().isEmpty()) {
            p = ((Channel)p.getIncomingChannels().get(0)).getSource();
        }
        if (p instanceof InputPort || p instanceof OutputPort && !p.getComponent().getContainedElements().isEmpty()) {
            return null;
        }
        return p.getComponent();
    }
}

