/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.generator.c;

import org.fortiss.af3.component.generator.c.CPortReplacement;
import org.fortiss.af3.component.model.generator.ComponentFunction;
import org.fortiss.af3.component.model.generator.ComponentProgram;
import org.fortiss.af3.component.model.generator.LocalFunction;
import org.fortiss.af3.component.model.generator.LocalVariable;
import org.fortiss.af3.component.model.generator.PortVariable;
import org.fortiss.af3.expression.generator.c.DataDictionaryToCSourcePackageTransformation;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.generator.common.model.c.CFunctionDefinition;
import org.fortiss.af3.generator.common.model.c.CHeaderFile;
import org.fortiss.af3.generator.common.model.c.CImplementationFile;
import org.fortiss.af3.generator.common.model.c.CModifier;
import org.fortiss.af3.generator.common.model.c.CSourcePackage;
import org.fortiss.af3.generator.common.model.c.CVariable;
import org.fortiss.af3.generator.common.model.source.Declaration;
import org.fortiss.af3.generator.common.model.source.Definition;
import org.fortiss.af3.generator.common.model.source.SourcePackage;
import org.fortiss.af3.generator.common.model.source.SourceUnit;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFacade;
import org.fortiss.af3.generator.common.utils.CLanguageModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.extension.base.TransformationProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;

public class ComponentProgramToCSourcePackageTransformation
extends TransformationProviderBase<ComponentProgram, CSourcePackage> {
    public static final String NOVAL_PORT_VARIABLE_PREFIX = "noval_";

    protected Class<ComponentProgram> getSourceClass() {
        return ComponentProgram.class;
    }

    public Class<CSourcePackage> getTargetClass() {
        return CSourcePackage.class;
    }

    public CSourcePackage transform(Object source, ITransformationContext context) throws TransformationFailedException {
        ComponentProgram p = (ComponentProgram)source;
        CSourcePackage pack = CLanguageModelElementFactory.createCSourcePackage();
        CHeaderFile hFile = CLanguageModelElementFactory.createHeaderFile((String)p.getName());
        CLanguageModelElementFacade.addGeneratedHeaderInclude((SourceUnit)hFile, (String)DataDictionaryToCSourcePackageTransformation.DATA_DICTIONARY_SOURCE_UNIT);
        CLanguageModelElementFacade.addGeneratedHeader((CHeaderFile)hFile, (CSourcePackage)pack);
        for (ComponentProgram sub : p.getSubPrograms()) {
            CSourcePackage subPack = this.transform(sub, context);
            subPack.mergeInto((SourcePackage)pack);
            CLanguageModelElementFacade.addGeneratedHeaderInclude((SourceUnit)hFile, (String)sub.getName());
        }
        CImplementationFile implFile = CLanguageModelElementFactory.createImplementationFile((String)p.getName());
        CLanguageModelElementFacade.addGeneratedHeaderInclude((SourceUnit)implFile, (String)p.getName());
        CLanguageModelElementFacade.addGeneratedSource((CImplementationFile)implFile, (CSourcePackage)pack);
        for (PortVariable portVar : p.getPortVariables()) {
            String portVarName = portVar.getVar().getIdentifier();
            CVariable portValue = CLanguageModelElementFactory.createCVariable((String)portVarName, (IType)portVar.getType());
            CVariable portNoVal = CLanguageModelElementFactory.createCVariable((String)ComponentProgramToCSourcePackageTransformation.getPortNoValIdentifier(portVarName), (IType)ExpressionModelElementFactory.boolType());
            CLanguageModelElementFacade.addExternVariableDeclaration((CHeaderFile)hFile, (CVariable)portValue);
            CLanguageModelElementFacade.addExternVariableDeclaration((CHeaderFile)hFile, (CVariable)portNoVal);
            CLanguageModelElementFacade.addVariableDeclaration((CImplementationFile)implFile, (CVariable)portValue);
            CLanguageModelElementFacade.addVariableDeclaration((CImplementationFile)implFile, (CVariable)portNoVal);
        }
        for (LocalVariable locVar : p.getLocalVariables()) {
            CVariable cLocal = CLanguageModelElementFactory.createCVariable((String)locVar.getVar().getIdentifier(), (IType)locVar.getType());
            CLanguageModelElementFacade.addDeclaration((SourceUnit)implFile, (Declaration)CLanguageModelElementFactory.createCVariableDeclaration((CModifier)CModifier.STATIC, (CVariable)cLocal));
        }
        this.addComponentFunction(p.getClearInputsFunction(), hFile, implFile);
        this.addComponentFunction(p.getClearOutputsFunction(), hFile, implFile);
        this.addComponentFunction(p.getInitializeFunction(), hFile, implFile);
        this.addComponentFunction(p.getPerformStepFunction(), hFile, implFile);
        for (LocalFunction locFun : p.getLocalFunctions()) {
            CFunctionDefinition cFun = this.createCFunctionFor(locFun);
            CLanguageModelElementFacade.addDeclaration((SourceUnit)implFile, (Declaration)CLanguageModelElementFactory.createCFunctionDeclaration((CModifier)CModifier.STATIC, (CFunctionDefinition)cFun));
            CLanguageModelElementFacade.addDefinition((SourceUnit)implFile, (Definition)cFun);
        }
        return pack;
    }

    private void addComponentFunction(ComponentFunction fun, CHeaderFile hFile, CImplementationFile implFile) {
        if (fun == null) {
            return;
        }
        CFunctionDefinition clearInputs = this.createCFunctionFor(fun);
        CLanguageModelElementFacade.addDeclaration((SourceUnit)hFile, (Declaration)CLanguageModelElementFactory.createCFunctionDeclaration((CModifier)CModifier.EXTERN, (CFunctionDefinition)clearInputs));
        CLanguageModelElementFacade.addDefinition((SourceUnit)implFile, (Definition)clearInputs);
    }

    public static String getPortNoValIdentifier(String pVar) {
        return NOVAL_PORT_VARIABLE_PREFIX + pVar;
    }

    private CFunctionDefinition createCFunctionFor(FunctionDefinition fun) {
        StatementSequence def = (StatementSequence)new CPortReplacement(fun.getDefinition()).apply();
        String name = fun.getFunction().getName();
        CFunctionDefinition result = CLanguageModelElementFactory.createCFunctionDefinition((String)name, (IType)fun.getReturnType(), (ITerm)def);
        for (FunctionParameter param : fun.getParameters()) {
            CLanguageModelElementFacade.addParameter((CFunctionDefinition)result, (String)param.getVar().getIdentifier(), (IType)param.getType());
        }
        return result;
    }
}

