/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.generator.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.generator.component.ComponentFunctionIdentifierUtils;
import org.fortiss.af3.component.generator.component.PortVariableUtils;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.generator.ComponentFunction;
import org.fortiss.af3.component.model.generator.ComponentProgram;
import org.fortiss.af3.component.model.generator.LocalFunction;
import org.fortiss.af3.component.model.generator.LocalVariable;
import org.fortiss.af3.component.model.generator.PortVariable;
import org.fortiss.af3.component.model.generator.port.WritePortVariableStatement;
import org.fortiss.af3.component.utils.GeneratorModelElementFactory;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.tooling.kernel.extension.base.TransformationProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.IdentifierUtils;

public abstract class ComponentProgramTransformationBase
extends TransformationProviderBase<Component, ComponentProgram> {
    protected Class<Component> getSourceClass() {
        return Component.class;
    }

    public Class<ComponentProgram> getTargetClass() {
        return ComponentProgram.class;
    }

    public boolean canTransform(Object source, ITransformationContext context) {
        return super.canTransform(source, context) && this.canTransformComponent((Component)source, context);
    }

    protected abstract boolean canTransformComponent(Component var1, ITransformationContext var2);

    public ComponentProgram transform(Object source, ITransformationContext context) throws TransformationFailedException {
        Component sourceComponent = (Component)source;
        String initName = ComponentFunctionIdentifierUtils.getInitializeFunctionName(sourceComponent);
        ComponentFunction init = GeneratorModelElementFactory.createComponentFunction(initName, null, this.createInitialization(sourceComponent));
        String performStepName = ComponentFunctionIdentifierUtils.getPerformStepFunctionName(sourceComponent);
        ComponentFunction performStep = GeneratorModelElementFactory.createComponentFunction(performStepName, null, this.createPerformStep(sourceComponent));
        ComponentProgram result = GeneratorModelElementFactory.createComponentProgram(IdentifierUtils.getUniqueIdentifier((INamedElement)sourceComponent), init, performStep);
        this.createPortInterfaceAndClearFunctions(sourceComponent, result);
        result.getLocalVariables().addAll(this.createLocalVariables(sourceComponent));
        result.getLocalFunctions().addAll(this.createLocalFunctions(sourceComponent));
        return result;
    }

    protected abstract StatementSequence createInitialization(Component var1);

    protected abstract StatementSequence createPerformStep(Component var1);

    protected List<LocalVariable> createLocalVariables(Component component) {
        return Collections.emptyList();
    }

    protected List<LocalFunction> createLocalFunctions(Component component) {
        return Collections.emptyList();
    }

    private void createPortInterfaceAndClearFunctions(Component component, ComponentProgram result) {
        ArrayList<IStatementTerm> clearFunctionBody = new ArrayList<IStatementTerm>();
        for (InputPort inport : component.getInputPorts()) {
            this.createPortInterface(result, inport, clearFunctionBody);
        }
        result.setClearInputsFunction(GeneratorModelElementFactory.createComponentFunction(ComponentFunctionIdentifierUtils.getClearInputsFunctionName(component), null, ExpressionModelElementFactory.sequence(clearFunctionBody)));
        clearFunctionBody.clear();
        for (OutputPort outport : component.getOutputPorts()) {
            this.createPortInterface(result, outport, clearFunctionBody);
        }
        result.setClearOutputsFunction(GeneratorModelElementFactory.createComponentFunction(ComponentFunctionIdentifierUtils.getClearOutputsFunctionName(component), null, ExpressionModelElementFactory.sequence(clearFunctionBody)));
    }

    private void createPortInterface(ComponentProgram result, Port port, List<IStatementTerm> clearFunctionBody) {
        PortVariable ppv = PortVariableUtils.getPortVariableFor(port);
        result.getPortVariables().add((Object)ppv);
        clearFunctionBody.add(GeneratorModelElementFactory.setPortVariable(ppv, GeneratorModelElementFactory.noValArgument()));
    }

    protected final StatementSequence createPortInitialization(Component component) {
        LinkedList<WritePortVariableStatement> body = new LinkedList<WritePortVariableStatement>();
        for (OutputPort op : component.getOutputPorts()) {
            body.add(PortVariableUtils.getPortAssignment(op, (IExpressionTerm)EcoreUtils.copy((EObject)op.getInitialValue())));
        }
        return ExpressionModelElementFactory.sequence(body);
    }
}

