/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.generator.component;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.generator.component.ComponentFunctionIdentifierUtils;
import org.fortiss.af3.component.generator.component.ComponentProgramTransformationBase;
import org.fortiss.af3.component.generator.component.PortVariableUtils;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.generator.ComponentProgram;
import org.fortiss.af3.component.model.generator.port.WritePortVariableStatement;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class CompositeComponentToComponentProgramTransformation
extends ComponentProgramTransformationBase {
    private List<Component> linearization;
    private Map<Port, Port> channels = new HashMap<Port, Port>();

    @Override
    public ComponentProgram transform(Object source, ITransformationContext context) throws TransformationFailedException {
        Component comp = (Component)source;
        this.channels.clear();
        this.linearization = comp.createLinearization();
        for (Component sub : this.linearization) {
            for (InputPort ip : sub.getInputPorts()) {
                Port src = ComponentArchitectureUtils.findSourcePort(comp, ip);
                if (src.getComponent() != comp && !this.linearization.contains(src.getComponent())) continue;
                this.channels.put(ip, src);
            }
        }
        for (OutputPort op : comp.getOutputPorts()) {
            Port src = ComponentArchitectureUtils.findSourcePort(comp, op);
            if (!this.linearization.contains(src.getComponent())) continue;
            this.channels.put(op, src);
        }
        ComponentProgram p = super.transform(source, context);
        for (Component sub : this.linearization) {
            ComponentProgram subProg = (ComponentProgram)TransformationUtils.createTransformedObjectFor((EObject)sub, ComponentProgram.class, (ITransformationContext)context);
            p.getSubPrograms().add((Object)subProg);
        }
        return p;
    }

    @Override
    protected StatementSequence createInitialization(Component component) {
        StatementSequence body = this.createPortInitialization(component);
        for (Component sub : this.linearization) {
            FunctionCall call = ExpressionModelElementFactory.funcCall((String)ComponentFunctionIdentifierUtils.getInitializeFunctionName(sub));
            body.getStatements().add((Object)ExpressionModelElementFactory.assignment((IExpressionTerm)call));
        }
        for (OutputPort op : component.getOutputPorts()) {
            Port src = this.channels.get(op);
            if (src == null) continue;
            body.getStatements().add((Object)PortVariableUtils.getPortPortValueAssignment(src, op));
        }
        return body;
    }

    @Override
    protected StatementSequence createPerformStep(Component component) {
        LinkedList<WritePortVariableStatement> body = new LinkedList<WritePortVariableStatement>();
        for (Port p : this.channels.keySet()) {
            Port src = this.channels.get(p);
            if (src.getComponent() != component && !src.getComponent().isStronglyCausal()) continue;
            body.add(PortVariableUtils.getPortPortValueAssignment(src, p));
        }
        for (Component sub : this.linearization) {
            body.add((WritePortVariableStatement)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)ComponentFunctionIdentifierUtils.getPerformStepFunctionName(sub))));
            if (sub.isStronglyCausal()) continue;
            for (Port p : this.channels.keySet()) {
                Port src = this.channels.get(p);
                if (src.getComponent() != sub) continue;
                body.add(PortVariableUtils.getPortPortValueAssignment(src, p));
            }
        }
        return ExpressionModelElementFactory.sequence(body);
    }

    @Override
    protected boolean canTransformComponent(Component source, ITransformationContext context) {
        return !source.getSubComponents().isEmpty() && this.canTransformSubComponents(source, context);
    }

    private boolean canTransformSubComponents(Component source, ITransformationContext context) {
        for (Component sub : source.getSubComponents()) {
            if (TransformationUtils.canTransform((EObject)sub, ComponentProgram.class, (ITransformationContext)context)) continue;
            return false;
        }
        return true;
    }
}

