/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.generator.component;

import org.fortiss.af3.component.generator.component.TermReplacement;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.generator.PortVariable;
import org.fortiss.af3.component.model.generator.port.ReadPortVariableExpression;
import org.fortiss.af3.component.model.generator.port.TestPortVariableExpression;
import org.fortiss.af3.component.model.generator.port.WritePortVariableStatement;
import org.fortiss.af3.component.utils.GeneratorModelElementFactory;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.utils.VariableScopeUtils;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.IdentifierUtils;

public final class PortVariableUtils {
    public static String getPortIdentifier(Port p) {
        return IdentifierUtils.getUniqueIdentifier((INamedElement)p);
    }

    public static WritePortVariableStatement getPortAssignment(Port p, IExpressionTerm value) {
        if (NoVal.isNoValConst((ITerm)value)) {
            return PortVariableUtils.getPortNoValAssignment(p);
        }
        if (PortVariableUtils.isPortReference(value)) {
            Port refPort = (Port)VariableScopeUtils.getVarDefinition((VarBase)((Var)value));
            return PortVariableUtils.getPortPortValueAssignment(refPort, p);
        }
        return PortVariableUtils.getPortValueAssignment(p, value);
    }

    public static boolean isPortReference(IExpressionTerm value) {
        return value instanceof Var && VariableScopeUtils.getVarDefinition((VarBase)((Var)value)) instanceof Port;
    }

    public static WritePortVariableStatement getPortPortValueAssignment(Port source, Port target) {
        return GeneratorModelElementFactory.setPortVariable(PortVariableUtils.getPortVariableFor(target), GeneratorModelElementFactory.portArgument(PortVariableUtils.getPortVariableFor(source)));
    }

    public static WritePortVariableStatement getPortValueAssignment(Port target, IExpressionTerm value) {
        IExpressionTerm replaced = (IExpressionTerm)new TermReplacement((ITerm)value).apply();
        return GeneratorModelElementFactory.setPortVariable(PortVariableUtils.getPortVariableFor(target), GeneratorModelElementFactory.valueArgument(replaced));
    }

    public static WritePortVariableStatement getPortNoValAssignment(Port target) {
        return GeneratorModelElementFactory.setPortVariable(PortVariableUtils.getPortVariableFor(target), GeneratorModelElementFactory.noValArgument());
    }

    public static PortVariable getPortVariableFor(Port port) {
        return GeneratorModelElementFactory.createPortVariable(PortVariableUtils.getPortIdentifier(port), port.getVariableType());
    }

    public static ReadPortVariableExpression getPortValue(Port port) {
        return GeneratorModelElementFactory.getPortVariable(PortVariableUtils.getPortVariableFor(port));
    }

    public static TestPortVariableExpression testPortVariableForNoVal(Port port) {
        return GeneratorModelElementFactory.testPortVariable(PortVariableUtils.getPortVariableFor(port), GeneratorModelElementFactory.noValArgument());
    }

    public static TestPortVariableExpression testPortVariableForValue(Port port, IExpressionTerm value) {
        return GeneratorModelElementFactory.testPortVariable(PortVariableUtils.getPortVariableFor(port), GeneratorModelElementFactory.valueArgument(value));
    }
}

