/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.generator.component;

import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.generator.component.PortVariableUtils;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.generator.PortVariable;
import org.fortiss.af3.component.model.generator.port.PortVariableOperationArgument;
import org.fortiss.af3.component.utils.GeneratorModelElementFactory;
import org.fortiss.af3.expression.AF3ExpressionActivator;
import org.fortiss.af3.expression.generator.TermReplacementVisitor;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.ArrayConst;
import org.fortiss.af3.expression.model.terms.ComplexVar;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.StructureConst;
import org.fortiss.af3.expression.model.terms.StructureMemberConst;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.impl.FunctionCallStaticImpl;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IFunction;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.utils.VariableScopeUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class TermReplacement
extends TermReplacementVisitor {
    public TermReplacement(ITerm toBeReplaced) {
        super(toBeReplaced);
    }

    protected ITerm applyToAssignment(Assignment term) {
        IVariableDefinition def = VariableScopeUtils.getVarDefinition((VarBase)term.getVariable());
        if (def instanceof OutputPort) {
            if (term.getVariable() instanceof ComplexVar) {
                LoggingUtils.warning((Plugin)AF3ExpressionActivator.getDefault(), (String)(String.valueOf(term.getVariable()) + " can not be used as a target variable. The output port must be written with complete data."));
            }
            PortVariable portVar = PortVariableUtils.getPortVariableFor((OutputPort)def);
            return GeneratorModelElementFactory.setPortVariable(portVar, this.getPortOperationArgument((ITerm)term.getValue()));
        }
        return super.applyToAssignment(term);
    }

    protected ITerm applyToFunctionCall(FunctionCall call) {
        if (call.getFunction() instanceof PredefinedFunction) {
            EOperator op = ((PredefinedFunction)call.getFunction()).getOperator();
            if (EOperator.EQUAL.equals((Object)op) || EOperator.NOT_EQUAL.equals((Object)op)) {
                IExpressionTerm replaced = null;
                if (this.checkTermForInputPortVar((ITerm)call.getArguments().get(0))) {
                    InputPort inport = (InputPort)VariableScopeUtils.getVarDefinition((VarBase)((Var)call.getArguments().get(0)));
                    replaced = this.applyEqualityReplacement(inport, (ITerm)call.getArguments().get(1));
                } else if (this.checkTermForInputPortVar((ITerm)call.getArguments().get(1))) {
                    InputPort inport = (InputPort)VariableScopeUtils.getVarDefinition((VarBase)((Var)call.getArguments().get(1)));
                    replaced = this.applyEqualityReplacement(inport, (ITerm)call.getArguments().get(0));
                }
                if (replaced != null) {
                    return EOperator.NOT_EQUAL.equals((Object)op) ? ExpressionModelElementFactory.not(replaced) : replaced;
                }
            } else if (EOperator.MEMBER.equals((Object)op)) {
                ArrayList<ITerm> newArgs = new ArrayList<ITerm>();
                for (ITerm arg : call.getArguments()) {
                    newArgs.add(this.applyInternal(arg));
                }
                FunctionCall newCall = FunctionCallStaticImpl.create((IFunction)((IFunction)EcoreUtils.copy((EObject)call.getFunction())));
                newCall.getArguments().add((Object)this.applyInternal((ITerm)call.getArguments().get(0)));
                newCall.getArguments().add((Object)((ITerm)EcoreUtils.copy((EObject)((ITerm)call.getArguments().get(1)))));
                return newCall;
            }
        }
        return super.applyToFunctionCall(call);
    }

    private boolean checkTermForInputPortVar(ITerm term) {
        return term instanceof Var && VariableScopeUtils.getVarDefinition((VarBase)((Var)term)) instanceof InputPort;
    }

    protected ITerm applyToVar(Var term) {
        IVariableDefinition def = VariableScopeUtils.getVarDefinition((VarBase)term);
        if (def instanceof InputPort) {
            return GeneratorModelElementFactory.getPortVariable(PortVariableUtils.getPortVariableFor((InputPort)def));
        }
        return super.applyToVar(term);
    }

    private IExpressionTerm applyEqualityReplacement(InputPort port, ITerm value) {
        if (value instanceof ArrayConst) {
            ArrayList<IExpressionTerm> seq = this.applyArrayConstEqualityReplacement((IExpressionTerm)ExpressionModelElementFactory.createVar((String)PortVariableUtils.getPortIdentifier(port)), (ArrayConst)value);
            seq.add(ExpressionModelElementFactory.not((IExpressionTerm)GeneratorModelElementFactory.testPortVariable(PortVariableUtils.getPortVariableFor(port), GeneratorModelElementFactory.noValArgument())));
            return ExpressionModelElementFactory.and(seq);
        }
        if (value instanceof StructureConst) {
            ArrayList<IExpressionTerm> seq = this.applyStructureConstEqualityReplacement((IExpressionTerm)ExpressionModelElementFactory.createVar((String)PortVariableUtils.getPortIdentifier(port)), (StructureConst)value);
            seq.add(ExpressionModelElementFactory.not((IExpressionTerm)GeneratorModelElementFactory.testPortVariable(PortVariableUtils.getPortVariableFor(port), GeneratorModelElementFactory.noValArgument())));
            return ExpressionModelElementFactory.and(seq);
        }
        return GeneratorModelElementFactory.testPortVariable(PortVariableUtils.getPortVariableFor(port), this.getPortOperationArgument(value));
    }

    protected ArrayList<IExpressionTerm> applyArrayConstEqualityReplacement(IExpressionTerm assignee, ArrayConst ac) {
        ArrayList<IExpressionTerm> seq = new ArrayList<IExpressionTerm>();
        int i = 0;
        while (i < ac.getValues().size()) {
            IExpressionTerm arrayMember = (IExpressionTerm)EcoreUtils.copy((EObject)((IExpressionTerm)ac.getValues().get(i)));
            FunctionCall arrayAccess = ExpressionModelElementFactory.arrayAccess((IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)assignee)), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)i));
            if (arrayMember instanceof ArrayConst) {
                seq.addAll(this.applyArrayConstEqualityReplacement((IExpressionTerm)arrayAccess, (ArrayConst)arrayMember));
            } else if (arrayMember instanceof StructureConst) {
                seq.addAll(this.applyStructureConstEqualityReplacement((IExpressionTerm)arrayAccess, (StructureConst)arrayMember));
            } else {
                seq.add((IExpressionTerm)ExpressionModelElementFactory.equal((IExpressionTerm)arrayAccess, (IExpressionTerm)arrayMember));
            }
            ++i;
        }
        return seq;
    }

    protected ArrayList<IExpressionTerm> applyStructureConstEqualityReplacement(IExpressionTerm assignee, StructureConst sc) {
        ArrayList<IExpressionTerm> seq = new ArrayList<IExpressionTerm>();
        for (StructureMemberConst smc : sc.getMembers()) {
            FunctionCall structAccess = ExpressionModelElementFactory.structAccess((IExpressionTerm)assignee, (String)smc.getName());
            if (smc.getValue() instanceof ArrayConst) {
                seq.addAll(this.applyArrayConstEqualityReplacement((IExpressionTerm)structAccess, (ArrayConst)smc.getValue()));
                continue;
            }
            if (smc.getValue() instanceof StructureConst) {
                seq.addAll(this.applyStructureConstEqualityReplacement((IExpressionTerm)structAccess, (StructureConst)smc.getValue()));
                continue;
            }
            seq.add((IExpressionTerm)ExpressionModelElementFactory.equal((IExpressionTerm)ExpressionModelElementFactory.funcCall((EOperator)EOperator.MEMBER, (IExpressionTerm)assignee, (IExpressionTerm)ExpressionModelElementFactory.createVar((String)smc.getName())), (IExpressionTerm)smc.getValue()));
        }
        return seq;
    }

    private PortVariableOperationArgument getPortOperationArgument(ITerm value) {
        IVariableDefinition def;
        if (NoVal.isNoValConst((ITerm)value)) {
            return GeneratorModelElementFactory.noValArgument();
        }
        if (value instanceof Var && (def = VariableScopeUtils.getVarDefinition((VarBase)((Var)value))) instanceof InputPort) {
            return GeneratorModelElementFactory.portArgument(PortVariableUtils.getPortVariableFor((InputPort)def));
        }
        return GeneratorModelElementFactory.valueArgument((IExpressionTerm)this.applyInternal(value));
    }
}

