/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.generator.fmu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.generator.c.ComponentProgramToCSourcePackageTransformation;
import org.fortiss.af3.component.generator.component.ComponentFunctionIdentifierUtils;
import org.fortiss.af3.component.generator.component.PortVariableUtils;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.BoolTypeDefinition;
import org.fortiss.af3.expression.model.definitions.DoubleTypeDefinition;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.IntTypeDefinition;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.terms.BoolConst;
import org.fortiss.af3.expression.model.terms.DoubleConst;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.generator.common.model.c.CFunctionDeclaration;
import org.fortiss.af3.generator.common.model.c.CHeaderFile;
import org.fortiss.af3.generator.common.model.c.CSourcePackage;
import org.fortiss.af3.generator.common.model.c.CVariableDeclaration;
import org.fortiss.af3.generator.common.model.fmu.AF3GeneratorCommonFMUFactory;
import org.fortiss.af3.generator.common.model.fmu.FMUArchivePackage;
import org.fortiss.af3.generator.common.model.fmu.FMUBooleanVariable;
import org.fortiss.af3.generator.common.model.fmu.FMUEnumerationVariable;
import org.fortiss.af3.generator.common.model.fmu.FMUIntegerVariable;
import org.fortiss.af3.generator.common.model.fmu.FMUItem;
import org.fortiss.af3.generator.common.model.fmu.FMUModelDescription;
import org.fortiss.af3.generator.common.model.fmu.FMURealVariable;
import org.fortiss.af3.generator.common.model.fmu.FMUTypeDefinition;
import org.fortiss.af3.generator.common.model.fmu.IFMUVariable;
import org.fortiss.af3.generator.common.model.source.Declaration;
import org.fortiss.af3.generator.common.model.source.SourcePackage;
import org.fortiss.af3.generator.common.utils.FMUUtils;
import org.fortiss.af3.generator.common.utils.SourceUtils;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.af3.project.utils.TypeScopeUtils;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.ITransformationProvider;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.IdentifierUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class ComponentArchitectureToFMUArchivePackageTransformation
implements ITransformationProvider {
    public Class<?> getTargetClass() {
        return FMUArchivePackage.class;
    }

    public boolean canHandleChainTransformation(Class<?> sourceClass, ITransformationContext context) {
        return ComponentArchitecture.class.isAssignableFrom(sourceClass) || Component.class.isAssignableFrom(sourceClass);
    }

    public boolean canTransform(Object source, ITransformationContext context) {
        return source instanceof ComponentArchitecture || source instanceof Component;
    }

    public Object transform(Object source, ITransformationContext context) throws TransformationFailedException {
        ComponentArchitecture componentArchitecture = null;
        if (source instanceof Component) {
            DataDictionary dd = DataDictionaryUtils.findDataDictionary((EObject)((Component)source));
            componentArchitecture = ComponentArchitectureUtils.createTemporaryComponentArchitecture((Component)EcoreUtils.copy((EObject)((Component)source)), dd);
        } else {
            componentArchitecture = (ComponentArchitecture)source;
        }
        Component component = componentArchitecture.getTopComponent();
        if (component == null) {
            throw new TransformationFailedException("The component architecture is empty.", (ITransformationProvider)this, null, null);
        }
        Set<Component> undefinedComponents = ComponentArchitectureUtils.getComponentsWithoutBehaviorDefinition(component);
        if (!undefinedComponents.isEmpty()) {
            String componentNames = String.join((CharSequence)", ", undefinedComponents.stream().map(c -> c.getName()).collect(Collectors.toSet()));
            String exceptionMessage = String.format("The following components have incorrect/missing behavior definition specification: %s", componentNames);
            throw new TransformationFailedException(exceptionMessage, (ITransformationProvider)this, null, null);
        }
        this.checkForIllegalNames(component);
        FMUArchivePackage fmuPackage = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUArchivePackage();
        CSourcePackage cSource = (CSourcePackage)TransformationUtils.createTransformedObjectFor((EObject)componentArchitecture, CSourcePackage.class, (ITransformationContext)context);
        fmuPackage.setCSource(cSource);
        CHeaderFile componentHeader = this.getHeaderFileFromSource(cSource, component);
        if (componentHeader == null) {
            throw new TransformationFailedException("Problem encountered during the export: Source corresponding to " + String.valueOf(component) + " not found or not generated. Please report.", (ITransformationProvider)this, null, null);
        }
        fmuPackage.setMainComponentHeader(componentHeader);
        DataDictionary dataDictionary = (DataDictionary)KernelModelElementUtils.getRootElement((EObject)componentArchitecture, DataDictionary.class);
        Map<Enumeration, FMUTypeDefinition> typeMap = this.createTypeMap(dataDictionary);
        this.addVariables(component, fmuPackage, componentHeader, typeMap);
        FMUModelDescription modelDescription = this.createModelDescription(component, fmuPackage, typeMap.values());
        fmuPackage.setModelDescription(modelDescription);
        String performStepFunctionName = ComponentFunctionIdentifierUtils.getPerformStepFunctionName(component);
        String initFunctionName = ComponentFunctionIdentifierUtils.getInitializeFunctionName(component);
        for (Declaration declaration : componentHeader.getDeclarations()) {
            if (!(declaration instanceof CFunctionDeclaration)) continue;
            String declarationName = ((CFunctionDeclaration)declaration).getDefinition().getName();
            if (declarationName.equals(performStepFunctionName)) {
                fmuPackage.setPerformStepFunction((CFunctionDeclaration)declaration);
            }
            if (!declarationName.equals(initFunctionName)) continue;
            fmuPackage.setInitFunction((CFunctionDeclaration)declaration);
        }
        return fmuPackage;
    }

    private void addVariables(Component component, FMUArchivePackage fmuPackage, CHeaderFile componentHeader, Map<Enumeration, FMUTypeDefinition> typeMap) throws TransformationFailedException {
        List<IFMUVariable> vars;
        int valueReferenceStart = 0;
        for (Port input : component.getInputPorts()) {
            vars = this.createIFMUVariables(input, valueReferenceStart, component, typeMap, componentHeader);
            fmuPackage.getInputs().addAll(vars);
            valueReferenceStart += vars.size();
        }
        for (Port output : component.getOutputPorts()) {
            vars = this.createIFMUVariables(output, valueReferenceStart, component, typeMap, componentHeader);
            fmuPackage.getOutputs().addAll(vars);
            valueReferenceStart += vars.size();
        }
    }

    private Map<Enumeration, FMUTypeDefinition> createTypeMap(DataDictionary dataDictionary) {
        HashMap<Enumeration, FMUTypeDefinition> typeMap = new HashMap<Enumeration, FMUTypeDefinition>();
        if (dataDictionary != null) {
            for (Enumeration enumeration : dataDictionary.getEnumerations()) {
                FMUTypeDefinition typeDefinition = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUTypeDefinition();
                typeDefinition.setName(enumeration.getName());
                typeDefinition.setComment(enumeration.getComment());
                for (EnumerationMember member : enumeration.getMembers()) {
                    FMUItem item = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUItem();
                    item.setName(member.getName());
                    item.setComment(member.getComment());
                    typeDefinition.getItems().add((Object)item);
                }
                typeMap.put(enumeration, typeDefinition);
            }
        }
        return typeMap;
    }

    private FMUModelDescription createModelDescription(Component component, FMUArchivePackage fmuPackage, Collection<FMUTypeDefinition> typeDefinitions) {
        FMUModelDescription modelDescription = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUModelDescription();
        modelDescription.setName(FMUUtils.toLegalName((String)component.getName()));
        modelDescription.setComment(component.getComment());
        modelDescription.getTypes().addAll(typeDefinitions);
        modelDescription.getInputVariables().addAll((Collection)fmuPackage.getInputs());
        modelDescription.getOutputVariables().addAll((Collection)fmuPackage.getOutputs());
        return modelDescription;
    }

    private CHeaderFile getHeaderFileFromSource(CSourcePackage cSource, Component component) {
        String componentHeader = IdentifierUtils.getUniqueIdentifier((INamedElement)component) + ".h";
        return (CHeaderFile)SourceUtils.findSourceUnitByName((String)componentHeader, (SourcePackage)cSource.getIncGenPackage(), CHeaderFile.class);
    }

    private List<IFMUVariable> createIFMUVariables(Port port, int valueReferenceStart, Component component, Map<Enumeration, FMUTypeDefinition> typeMap, CHeaderFile componentHeader) throws TransformationFailedException {
        ITypeDefinition typeDefinition = TypeScopeUtils.getTypeDefinition((IType)port.getVariableType(), (EObject)component);
        if (typeDefinition instanceof Array) {
            throw new TransformationFailedException("The type of the port " + port.getName() + " is an array, which is not supported by the FMI standard.", (ITransformationProvider)this, null, null);
        }
        if (typeDefinition instanceof Structure) {
            ArrayList<IFMUVariable> variables = new ArrayList<IFMUVariable>();
            for (StructureMember member : ((Structure)typeDefinition).getMembers()) {
                FMURealVariable variable = null;
                if (member.getType() instanceof TDouble) {
                    variable = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMURealVariable();
                } else if (member.getType() instanceof TInt) {
                    variable = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUIntegerVariable();
                } else if (member.getType() instanceof TBool) {
                    variable = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUBooleanVariable();
                } else if (TypeScopeUtils.getTypeDefinition((IType)member.getType(), (EObject)component) instanceof Enumeration) {
                    variable = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUEnumerationVariable();
                    ITypeDefinition memberTypeDef = TypeScopeUtils.getTypeDefinition((IType)member.getType(), (EObject)component);
                    ((FMUEnumerationVariable)variable).setType(typeMap.get(memberTypeDef));
                }
                if (variable != null) {
                    this.fillInIFMUBundledVariable((IFMUVariable)variable, member, port, valueReferenceStart++);
                    variables.add((IFMUVariable)variable);
                    continue;
                }
                throw new TransformationFailedException("Cannot transform structure member of type " + member.getType().getTypeClassName(), (ITransformationProvider)this, null, null);
            }
            return variables;
        }
        if (typeDefinition instanceof Enumeration) {
            FMUEnumerationVariable variable = this.createFMUEnumerationVariable(port, valueReferenceStart, component, typeMap, componentHeader);
            return Collections.singletonList(variable);
        }
        if (port.getVariableType() instanceof TInt || typeDefinition instanceof IntTypeDefinition) {
            FMUIntegerVariable variable = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUIntegerVariable();
            this.fillInIFMUVariable((IFMUVariable)variable, componentHeader, port, valueReferenceStart);
            if (port.getInitialValue() != null && port.getInitialValue() instanceof IntConst) {
                int initialValue = ((IntConst)port.getInitialValue()).getValue();
                variable.setStart(initialValue);
            }
            return Collections.singletonList(variable);
        }
        if (port.getVariableType() instanceof TBool || typeDefinition instanceof BoolTypeDefinition) {
            FMUBooleanVariable variable = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUBooleanVariable();
            this.fillInIFMUVariable((IFMUVariable)variable, componentHeader, port, valueReferenceStart);
            if (port.getInitialValue() != null && port.getInitialValue() instanceof BoolConst) {
                boolean initialValue = ((BoolConst)port.getInitialValue()).getValue();
                variable.setStart(initialValue);
            }
            return Collections.singletonList(variable);
        }
        if (port.getVariableType() instanceof TDouble || typeDefinition instanceof DoubleTypeDefinition) {
            FMURealVariable variable = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMURealVariable();
            this.fillInIFMUVariable((IFMUVariable)variable, componentHeader, port, valueReferenceStart);
            if (port.getInitialValue() != null && port.getInitialValue() instanceof DoubleConst) {
                double initialValue = ((DoubleConst)port.getInitialValue()).getValue();
                variable.setStart(initialValue);
            }
            return Collections.singletonList(variable);
        }
        throw new TransformationFailedException("The type of the port " + port.getName() + " is not supported by the FMI standard.", (ITransformationProvider)this, null, null);
    }

    private FMUEnumerationVariable createFMUEnumerationVariable(Port port, int valueReferenceStart, Component component, Map<Enumeration, FMUTypeDefinition> typeMap, CHeaderFile componentHeader) {
        FunctionCall functionCall;
        FMUEnumerationVariable variable = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUEnumerationVariable();
        ITypeDefinition typeDefinition = TypeScopeUtils.getTypeDefinition((IType)port.getVariableType(), (EObject)component);
        this.fillInIFMUVariable((IFMUVariable)variable, componentHeader, port, valueReferenceStart);
        variable.setType(typeMap.get(typeDefinition));
        if (port.getInitialValue() != null && port.getInitialValue() instanceof FunctionCall && (functionCall = (FunctionCall)port.getInitialValue()).getFunction() instanceof UserdefinedFunction) {
            UserdefinedFunction enumMember = (UserdefinedFunction)functionCall.getFunction();
            EList allMembers = ((Enumeration)typeDefinition).getMembers();
            int i = 0;
            while (i < allMembers.size()) {
                if (((EnumerationMember)allMembers.get(i)).getName().equals(enumMember.getName())) {
                    variable.setStart((FMUItem)typeMap.get(typeDefinition).getItems().get(i));
                }
                ++i;
            }
        }
        return variable;
    }

    private void fillInIFMUBundledVariable(IFMUVariable variable, StructureMember member, Port port, int refID) {
        variable.setName(port.getName() + "__" + member.getName());
        variable.setComment(member.getComment());
        variable.setCVariableName(PortVariableUtils.getPortIdentifier(port) + "." + member.getName());
        variable.setCNoValVariableName(ComponentProgramToCSourcePackageTransformation.getPortNoValIdentifier(PortVariableUtils.getPortIdentifier(port)));
        variable.setId(refID);
    }

    private void fillInIFMUVariable(IFMUVariable variable, CHeaderFile componentHeader, Port input, int referenceID) {
        variable.setName(input.getName());
        variable.setComment(input.getComment());
        variable.setId(referenceID);
        String id = PortVariableUtils.getPortIdentifier(input);
        String noValId = ComponentProgramToCSourcePackageTransformation.getPortNoValIdentifier(id);
        for (Declaration declaration : componentHeader.getDeclarations()) {
            if (!(declaration instanceof CVariableDeclaration)) continue;
            if (((CVariableDeclaration)declaration).getVariable().getName().equals(id)) {
                variable.setCVariableName(id);
            }
            if (!((CVariableDeclaration)declaration).getVariable().getName().equals(noValId)) continue;
            variable.setCNoValVariableName(noValId);
        }
    }

    private void checkForIllegalNames(Component component) throws TransformationFailedException {
        CharSequence[] illegalStrings = new CharSequence[]{"  ", "__"};
        Collection<Component> illegalComponents = ComponentArchitectureToFMUArchivePackageTransformation.getIllegalNames((IHierarchicElement)component, Component.class, illegalStrings);
        Collection<Port> illegalPorts = ComponentArchitectureToFMUArchivePackageTransformation.getIllegalNames((IHierarchicElement)component, Port.class, illegalStrings);
        Collection illegalMembers = EcoreUtils.getChildrenWithType((EObject)component, Port.class).stream().map(port -> TypeScopeUtils.getTypeDefinition((IType)port.getVariableType(), (EObject)component)).filter(typeDefinition -> typeDefinition instanceof Structure).map(typeDefinition -> (Structure)typeDefinition).flatMap(structure -> ComponentArchitectureToFMUArchivePackageTransformation.getIllegalNames((IHierarchicElement)structure, StructureMember.class, illegalStrings).stream()).collect(Collectors.toSet());
        if (!(illegalComponents.isEmpty() && illegalPorts.isEmpty() && illegalMembers.isEmpty())) {
            throw new TransformationFailedException("The behavior specification to be exported as FMU contains components, ports or members with illegal names.", (ITransformationProvider)this, null, null);
        }
    }

    private static <T extends INamedElement> Collection<T> getIllegalNames(IHierarchicElement hierarchicElement, Class<T> namedElementClass, CharSequence ... illegalSequences) {
        return EcoreUtils.getChildrenWithType((EObject)hierarchicElement, namedElementClass).stream().filter(element -> Arrays.stream(illegalSequences).anyMatch(string -> element.getName().contains((CharSequence)string))).collect(Collectors.toSet());
    }
}

