/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.generator.java;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.generator.common.model.java.JavaSourcePackage;
import org.fortiss.af3.generator.common.model.source.SourcePackage;
import org.fortiss.af3.generator.common.utils.JavaLanguageModelElementFactory;
import org.fortiss.tooling.kernel.extension.ITransformationProvider;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class ComponentArchitectureToJavaSourcePackageTransformation
implements ITransformationProvider {
    public Class<?> getTargetClass() {
        return JavaSourcePackage.class;
    }

    public boolean canHandleChainTransformation(Class<?> sourceClass, ITransformationContext context) {
        return ComponentArchitecture.class.isAssignableFrom(sourceClass);
    }

    public boolean canTransform(Object source, ITransformationContext context) {
        return source instanceof ComponentArchitecture;
    }

    public Object transform(Object source, ITransformationContext context) throws TransformationFailedException {
        JavaSourcePackage result = JavaLanguageModelElementFactory.createJavaSourcePackage();
        Component sourceComponent = ((ComponentArchitecture)source).getTopComponent();
        JavaSourcePackage compSource = (JavaSourcePackage)TransformationUtils.createTransformedObjectFor((EObject)sourceComponent, JavaSourcePackage.class, (ITransformationContext)context);
        compSource.mergeInto((SourcePackage)result);
        DataDictionary dataDict = (DataDictionary)KernelModelElementUtils.getRootElement((EObject)sourceComponent, DataDictionary.class);
        if (dataDict == null) {
            dataDict = ExpressionModelElementFactory.createDataDictionary();
        }
        JavaSourcePackage dataDictionaryPackage = (JavaSourcePackage)TransformationUtils.createTransformedObjectFor((EObject)dataDict, JavaSourcePackage.class, (ITransformationContext)context);
        dataDictionaryPackage.mergeInto((SourcePackage)result);
        return result;
    }
}

