/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.generator.java;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.generator.java.JavaReplacement;
import org.fortiss.af3.component.model.generator.ComponentFunction;
import org.fortiss.af3.component.model.generator.ComponentProgram;
import org.fortiss.af3.component.model.generator.LocalFunction;
import org.fortiss.af3.component.model.generator.LocalVariable;
import org.fortiss.af3.component.model.generator.PortVariable;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.generator.common.model.java.JavaClass;
import org.fortiss.af3.generator.common.model.java.JavaFile;
import org.fortiss.af3.generator.common.model.java.JavaMethodDefinition;
import org.fortiss.af3.generator.common.model.java.JavaSourcePackage;
import org.fortiss.af3.generator.common.model.java.JavaType;
import org.fortiss.af3.generator.common.model.java.JavaVariable;
import org.fortiss.af3.generator.common.model.java.JavaVariableDeclaration;
import org.fortiss.af3.generator.common.model.source.Declaration;
import org.fortiss.af3.generator.common.model.source.Definition;
import org.fortiss.af3.generator.common.model.source.SourcePackage;
import org.fortiss.af3.generator.common.utils.JavaLanguageModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.extension.base.TransformationProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.ChainTransformationFailedException;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class ComponentProgramToJavaSourcePackageTransformation
extends TransformationProviderBase<ComponentProgram, JavaSourcePackage> {
    public static final String COMPONENT_JAVA_PACKAGE = "af3.javagen.component";

    protected Class<ComponentProgram> getSourceClass() {
        return ComponentProgram.class;
    }

    public Class<JavaSourcePackage> getTargetClass() {
        return JavaSourcePackage.class;
    }

    public JavaSourcePackage transform(Object source, ITransformationContext context) throws TransformationFailedException {
        ComponentProgram p = (ComponentProgram)source;
        JavaSourcePackage pack = JavaLanguageModelElementFactory.createJavaSourcePackage();
        JavaClass implFile = JavaLanguageModelElementFactory.createPublicJavaClass((String)COMPONENT_JAVA_PACKAGE, (String)p.getName());
        pack.addGeneratedSource((JavaFile)implFile);
        implFile.getImports().add((Object)JavaLanguageModelElementFactory.createImport((String)"af3.javagen.datadictionary.DataDictionary.*", (boolean)true));
        implFile.getImports().add((Object)JavaLanguageModelElementFactory.createImport((String)"af3.javagen.datadictionary.*", (boolean)false));
        for (ComponentProgram sub : p.getSubPrograms()) {
            JavaSourcePackage subPack = this.transform(sub, context);
            subPack.mergeInto((SourcePackage)pack);
            implFile.getImports().add((Object)JavaLanguageModelElementFactory.createImport((String)("af3.javagen.component." + sub.getName() + ".*"), (boolean)true));
        }
        for (PortVariable portVar : p.getPortVariables()) {
            String portVarName = portVar.getVar().getIdentifier();
            String portVarType = (String)TransformationUtils.createTransformedObjectFor((EObject)portVar.getType(), String.class, (ITransformationContext)context);
            JavaVariable portValue = JavaLanguageModelElementFactory.createJavaVariable((String)portVarName, (JavaType)JavaLanguageModelElementFactory.createJavaType((String)portVarType));
            JavaVariableDeclaration varDecl = JavaLanguageModelElementFactory.createJavaVariableDeclaration((List)JavaLanguageModelElementFactory.PUBLIC_STATIC, (JavaVariable)portValue);
            implFile.addDeclaration((Declaration)varDecl);
        }
        for (LocalVariable locVar : p.getLocalVariables()) {
            String locVarType = (String)TransformationUtils.createTransformedObjectFor((EObject)locVar.getType(), String.class, (ITransformationContext)context);
            JavaVariable jLocal = JavaLanguageModelElementFactory.createJavaVariable((String)locVar.getVar().getIdentifier(), (JavaType)JavaLanguageModelElementFactory.createJavaType((String)locVarType));
            JavaVariableDeclaration varDecl = JavaLanguageModelElementFactory.createJavaVariableDeclaration((List)JavaLanguageModelElementFactory.PUBLIC_STATIC, (JavaVariable)jLocal);
            implFile.addDeclaration((Declaration)varDecl);
        }
        this.addComponentFunction(p.getClearInputsFunction(), implFile, context);
        this.addComponentFunction(p.getClearOutputsFunction(), implFile, context);
        this.addComponentFunction(p.getInitializeFunction(), implFile, context);
        this.addComponentFunction(p.getPerformStepFunction(), implFile, context);
        for (LocalFunction locFun : p.getLocalFunctions()) {
            JavaMethodDefinition jFun = this.createJavaMethodFor(locFun, context);
            implFile.addDefinition((Definition)jFun);
        }
        return pack;
    }

    private void addComponentFunction(ComponentFunction fun, JavaClass implFile, ITransformationContext context) throws ChainTransformationFailedException {
        if (fun == null) {
            return;
        }
        JavaMethodDefinition jFun = this.createJavaMethodFor(fun, context);
        implFile.addDefinition((Definition)jFun);
    }

    private JavaMethodDefinition createJavaMethodFor(FunctionDefinition fun, ITransformationContext context) throws ChainTransformationFailedException {
        StatementSequence def = (StatementSequence)new JavaReplacement(fun.getDefinition()).apply();
        String name = fun.getFunction().getName();
        IType funRetType = fun.getReturnType();
        if (funRetType == null) {
            funRetType = ExpressionModelElementFactory.createUnboundDefinedType((String)"void");
        }
        String retType = (String)TransformationUtils.createTransformedObjectFor((EObject)funRetType, String.class, (ITransformationContext)context);
        JavaMethodDefinition result = JavaLanguageModelElementFactory.createJavaMethodDefinition((List)JavaLanguageModelElementFactory.PUBLIC_STATIC, (String)name, (JavaType)JavaLanguageModelElementFactory.createJavaType((String)retType), (ITerm)def);
        for (FunctionParameter param : fun.getParameters()) {
            String paramType = (String)TransformationUtils.createTransformedObjectFor((EObject)param.getType(), String.class, (ITransformationContext)context);
            result.addParameter(param.getVar().getIdentifier(), JavaLanguageModelElementFactory.createJavaType((String)paramType));
        }
        return result;
    }
}

