/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.listener;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.fortiss.af3.component.AF3ComponentActivator;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.code.CodeSpecification;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class CodeSpecRenameListener
extends EContentAdapter {
    private static volatile CodeSpecRenameListener INSTANCE;

    private CodeSpecRenameListener() {
    }

    public static synchronized CodeSpecRenameListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CodeSpecRenameListener();
        }
        return INSTANCE;
    }

    public static void installRenamingListeners(ITopLevelElement element) {
        EObject rootElement = element.getRootModelElement();
        if (!(rootElement instanceof FileProject)) {
            LoggingUtils.warning((Plugin)AF3ComponentActivator.getDefault(), (String)"Got a root element that is not a file project while trying to install listeners. This could indicate a model corruption.");
            return;
        }
        FileProject fileProject = (FileProject)rootElement;
        EList componentArchitectures = EcoreUtils.pickInstanceOf(ComponentArchitecture.class, (List)fileProject.getRootElements());
        LambdaUtils.filter((Collection)componentArchitectures, ca -> !ca.eAdapters().contains((Object)CodeSpecRenameListener.getInstance())).forEach(ca -> {
            boolean bl = ca.eAdapters().add((Object)CodeSpecRenameListener.getInstance());
        });
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getNotifier() instanceof Port && notification.getEventType() == 1) {
            if (!(notification.getFeature() instanceof EAttribute)) {
                return;
            }
            EAttribute attribute = (EAttribute)notification.getFeature();
            if (!attribute.getName().equals("name")) {
                return;
            }
            Component parentComponent = ((Port)notification.getNotifier()).getComponent();
            CodeSpecification codeSpec = (CodeSpecification)EcoreUtils.pickFirstInstanceOf(CodeSpecification.class, (List)parentComponent.getSpecifications());
            if (codeSpec == null) {
                return;
            }
            this.renameVariables(notification, (EObject)codeSpec);
            codeSpec.setStringRepresentation(codeSpec.getBody().toString());
        }
    }

    private void renameVariables(Notification notification, EObject container) {
        EList variables = EcoreUtils.getChildrenWithType((EObject)container, Var.class);
        String oldName = notification.getOldStringValue();
        String newName = notification.getNewStringValue();
        Collection variableMatch = LambdaUtils.filter((Collection)variables, v -> v.getIdentifier().equals(oldName));
        variableMatch.forEach(v -> v.setIdentifier(newName));
    }
}

