/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.model.impl;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.DataDictionaryRefSpec;
import org.fortiss.af3.component.model.impl.ComponentArchitectureImpl;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.project.model.typesystem.FunctionCallBase;
import org.fortiss.af3.project.model.typesystem.IFunctionDefinition;
import org.fortiss.af3.project.model.typesystem.IFunctionScope;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

class ComponentArchitectureStaticImpl {
    ComponentArchitectureStaticImpl() {
    }

    static Component getTopComponent(ComponentArchitecture ca) {
        EList contained = ca.getContainedElements();
        if (contained != null && !contained.isEmpty()) {
            return (Component)ca.getContainedElements().get(0);
        }
        return null;
    }

    static EList<ITypeDefinition> getITypeDefinitions(ComponentArchitecture ca) {
        DataDictionary dict = ComponentArchitectureStaticImpl.findAssociatedDataDictionary(ca);
        if (dict != null) {
            return EcoreUtils.generalizeList(ITypeDefinition.class, (EList)dict.getTypeDefinitions());
        }
        return new BasicEList();
    }

    static EList<IFunctionDefinition> getIFunctionDefinitions(ComponentArchitecture ca) {
        DataDictionary dict = ComponentArchitectureStaticImpl.findAssociatedDataDictionary(ca);
        if (dict != null) {
            return EcoreUtils.generalizeList(IFunctionDefinition.class, (EList)dict.getFunctions());
        }
        return new BasicEList();
    }

    static IFunctionDefinition getDefinitionElement(ComponentArchitecture componentArchitecture, FunctionCallBase call) {
        EList project = componentArchitecture.eContainer().eContents();
        EList scopes = EcoreUtils.pickInstanceOf(IFunctionScope.class, (List)project);
        for (IFunctionScope scope : scopes) {
            IFunctionDefinition def;
            if (scope instanceof ComponentArchitecture || (def = scope.getDefinitionElement(call)) == null) continue;
            return def;
        }
        return null;
    }

    static ITypeDefinition getDefinitionElement(ComponentArchitecture ca, IType type) {
        DataDictionary dict = ComponentArchitectureStaticImpl.findAssociatedDataDictionary(ca);
        if (dict != null) {
            return dict.getDefinitionElement(type);
        }
        return null;
    }

    private static DataDictionary findAssociatedDataDictionary(ComponentArchitecture ca) {
        DataDictionaryRefSpec ddRef = (DataDictionaryRefSpec)EcoreUtils.pickFirstInstanceOf(DataDictionaryRefSpec.class, (List)ca.getSpecifications());
        if (ddRef == null) {
            return (DataDictionary)EcoreUtils.pickFirstInstanceOf(DataDictionary.class, (List)ca.eContainer().eContents());
        }
        return ddRef.getDataDictionary();
    }

    static void setName(ComponentArchitectureImpl componentArchitectureImpl, String name) {
        componentArchitectureImpl.name = name;
        Component topComponent = componentArchitectureImpl.getTopComponent();
        if (topComponent != null) {
            topComponent.setName(name);
        }
    }
}

