/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.CausalityComponentSpecification;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.code.CodeSpecification;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.model.typesystem.IVariableScope;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

class ComponentStaticImpl {
    private static final Comparator<Pair<Component, Component>> edgeComparator = new Comparator<Pair<Component, Component>>(){

        @Override
        public int compare(Pair<Component, Component> p1, Pair<Component, Component> p2) {
            return ((Component)p2.getSecond()).getId() - ((Component)p1.getSecond()).getId();
        }
    };

    ComponentStaticImpl() {
    }

    static EList<OutputPort> getOutputPorts(Component comp) {
        return EcoreUtils.pickInstanceOf(OutputPort.class, (List)comp.getConnectors());
    }

    static EList<InputPort> getInputPorts(Component comp) {
        return EcoreUtils.pickInstanceOf(InputPort.class, (List)comp.getConnectors());
    }

    static EList<Channel> getChannels(Component comp) {
        return EcoreUtils.convertList(Channel.class, (EList)comp.getConnections());
    }

    static EList<Component> getSubComponents(Component comp) {
        return EcoreUtils.pickInstanceOf(Component.class, (List)comp.getContainedElements());
    }

    static IVariableDefinition getDefinitionElement(Component comp, VarBase var) {
        InputPort inputPort = ComponentStaticImpl.findInputPort(comp, var.getIdentifier());
        if (inputPort != null) {
            return inputPort;
        }
        return ComponentStaticImpl.findOutputPort(comp, var.getIdentifier());
    }

    static Component getParentComponent(Component comp) {
        if (comp.eContainer() instanceof Component) {
            return (Component)comp.eContainer();
        }
        return null;
    }

    static CausalityComponentSpecification getCausalitySpecification(Component comp) {
        return (CausalityComponentSpecification)EcoreUtils.pickFirstInstanceOf(CausalityComponentSpecification.class, (List)comp.getSpecifications());
    }

    static boolean isStronglyCausal(Component comp) {
        return comp.getCausalitySpecification().isStronglyCausal();
    }

    static IVariableScope getParentVariableScope(Component comp) {
        return null;
    }

    public static CodeSpecification getCodeSpecification(Component component) {
        return (CodeSpecification)EcoreUtils.pickFirstInstanceOf(CodeSpecification.class, (List)component.getSpecifications());
    }

    static EList<Component> findWeaklyCausalComponents(Component component) {
        BasicEList result = new BasicEList();
        ComponentStaticImpl.findWeaklyCausalComponents(component, (EList<Component>)result);
        return result;
    }

    private static void findWeaklyCausalComponents(Component component, EList<Component> result) {
        if (component.getContainedElements().isEmpty()) {
            if (!component.isStronglyCausal()) {
                result.add((Object)component);
            }
        } else {
            for (Component sub : component.getSubComponents()) {
                ComponentStaticImpl.findWeaklyCausalComponents(sub, result);
            }
        }
    }

    static EList<Component> createLinearization(Component boundary) {
        return ComponentStaticImpl.createLinearization(boundary, null);
    }

    private static EList<Component> createLinearization(Component boundary, Collection<? extends Component> atomics) {
        if (atomics == null) {
            atomics = ComponentStaticImpl.findAtomicComponents(boundary);
        }
        BasicEList weak = new BasicEList();
        BasicEList strong = new BasicEList();
        ComponentStaticImpl.sortAtomicComponents(atomics, (Collection<Component>)weak, (Collection<Component>)strong);
        return ComponentStaticImpl.createLinearization(boundary, (Collection<Component>)weak, (Collection<Component>)strong);
    }

    private static void sortAtomicComponents(Collection<? extends Component> atomics, Collection<Component> weak, Collection<Component> strong) {
        for (Component component : atomics) {
            if (component.isStronglyCausal()) {
                strong.add(component);
                continue;
            }
            weak.add(component);
        }
    }

    private static EList<Component> createLinearization(Component boundary, Collection<Component> weak, Collection<Component> strong) {
        HashSet<Pair> edges = new HashSet<Pair>();
        for (Component wc : weak) {
            for (InputPort p : wc.getInputPorts()) {
                Port source = ComponentArchitectureUtils.findSourcePort(boundary, p);
                if (!weak.contains(source.getComponent())) continue;
                edges.add(new Pair((Object)wc, (Object)source.getComponent()));
            }
        }
        LinkedList<Pair<Component, Component>> sortedEdges = new LinkedList<Pair<Component, Component>>();
        sortedEdges.addAll(edges);
        Collections.sort(sortedEdges, edgeComparator);
        BasicEList result = new BasicEList();
        BasicEList visited = new BasicEList();
        for (Component wc : weak) {
            ComponentStaticImpl.visit(wc, (List<Component>)result, (List<Component>)visited, sortedEdges);
        }
        result.addAll(strong);
        return result;
    }

    private static void visit(Component comp, List<Component> result, List<Component> visited, Collection<Pair<Component, Component>> edges) {
        if (!visited.contains(comp)) {
            visited.add(comp);
            for (Pair<Component, Component> edge : edges) {
                if (edge.getFirst() != comp) continue;
                ComponentStaticImpl.visit((Component)edge.getSecond(), result, visited, edges);
            }
            result.add(comp);
        }
    }

    static Component findSubComponent(Component parent, String name) {
        if (parent != null) {
            for (Component comp : parent.getSubComponents()) {
                if (!comp.getName().equals(name)) continue;
                return comp;
            }
        }
        return null;
    }

    static Component findSubComponentRecursively(Component parent, String name) {
        for (Component comp : ComponentStaticImpl.getAllSubComponentRecursively(parent)) {
            if (!comp.getName().equals(name)) continue;
            return comp;
        }
        return null;
    }

    private static EList<Component> getAllSubComponentRecursively(Component parent) {
        return EcoreUtils.getChildrenWithType((EObject)parent, Component.class);
    }

    static OutputPort findOutputPort(Component component, String portName) {
        for (OutputPort output : component.getOutputPorts()) {
            if (!output.getName().equals(portName)) continue;
            return output;
        }
        return null;
    }

    static InputPort findInputPort(Component component, String portName) {
        for (InputPort input : component.getInputPorts()) {
            if (!input.getName().equals(portName)) continue;
            return input;
        }
        return null;
    }

    static Component getTopComponentParent(Component component) {
        Component parent = component;
        while (parent.getContainer() instanceof Component) {
            parent = (Component)parent.getContainer();
        }
        return parent;
    }

    static EList<Component> getParentComponents(Component component) {
        BasicEList parents = new BasicEList();
        if (component != null) {
            EObject parent = component.eContainer();
            while (parent != null && !(parent instanceof ComponentArchitecture)) {
                if (parent instanceof Component) {
                    parents.add((Object)((Component)parent));
                }
                parent = parent.eContainer();
            }
        }
        return parents;
    }

    static EList<Component> findAtomicComponents(Component boundary) {
        BasicEList result = new BasicEList();
        if (boundary != null) {
            LinkedList<Component> componentStack = new LinkedList<Component>();
            componentStack.addAll((Collection<Component>)boundary.getSubComponents());
            while (!componentStack.isEmpty()) {
                Component cur = (Component)componentStack.poll();
                if (cur.getContainedElements().isEmpty()) {
                    result.add((Object)cur);
                    continue;
                }
                componentStack.addAll((Collection<Component>)cur.getSubComponents());
            }
        }
        return result;
    }

    public static void specialCopyHook(Component comp, Map<EObject, EObject> objs) {
        BasicEList ports = new BasicEList(comp.getInputPorts());
        ports.addAll(comp.getOutputPorts());
        for (Port p : ports) {
            p.specialCopyHook(objs);
        }
    }
}

