/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.model.impl;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.AF3ComponentFactory;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.component.utils.ComponentUtils;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

class PortStaticImpl {
    PortStaticImpl() {
    }

    static PortSpecification getPortSpecification(Port port) {
        return (PortSpecification)EcoreUtils.pickFirstInstanceOf(PortSpecification.class, (List)port.getSpecifications());
    }

    static Component getComponent(Port port) {
        return (Component)port.eContainer();
    }

    static EList<Channel> getOutgoingChannels(Port port) {
        return EcoreUtils.pickInstanceOf(Channel.class, (List)port.getOutgoing());
    }

    static EList<Channel> getIncomingChannels(Port port) {
        return EcoreUtils.pickInstanceOf(Channel.class, (List)port.getIncoming());
    }

    static IType getVariableType(Port port) {
        return port.getPortSpecification().getType();
    }

    static Var getVar(Port port) {
        return VarStaticImpl.create((String)port.getName());
    }

    static IExpressionTerm getInitialValue(Port port) {
        return port.getPortSpecification().getInitialValue();
    }

    public static void specialCopyHook(Port port, Map<EObject, EObject> copyMap) {
        for (Channel c : port.getOutgoingChannels()) {
            if ((Port)copyMap.get(c.getTarget()) == null) continue;
            PortStaticImpl.copyChannel(c, copyMap, PortStaticImpl.findParent(port, c.getTarget(), copyMap));
        }
        for (Channel c : port.getIncomingChannels()) {
            if ((Port)copyMap.get(c.getSource()) == null) continue;
            PortStaticImpl.copyChannel(c, copyMap, PortStaticImpl.findParent(port, c.getSource(), copyMap));
        }
    }

    private static Component findParent(Port port1, Port port2, Map<EObject, EObject> copyMap) {
        Component port2Comp;
        Component port1Comp = PortStaticImpl.obtainComponent(port1, copyMap);
        if (port1Comp.equals(port2Comp = PortStaticImpl.obtainComponent(port2, copyMap))) {
            return port1Comp;
        }
        Component port1Parent = PortStaticImpl.obtainParent(port1.getComponent(), copyMap);
        if (port2Comp.equals(port1Parent)) {
            return port1Parent;
        }
        Component port2Parent = PortStaticImpl.obtainParent(port2.getComponent(), copyMap);
        if (port1Comp.equals(port2Parent)) {
            return port2Parent;
        }
        if (port1Parent.equals(port2Parent)) {
            return port1Parent;
        }
        return null;
    }

    private static Component createCounterPartComponent(Component component) {
        Component compCounterpart = AF3ComponentFactory.eINSTANCE.createComponent();
        compCounterpart.setName(component.getName() + "_FAKE_COPY");
        return compCounterpart;
    }

    public static Component obtainComponent(Port port, Map<EObject, EObject> copyMap) {
        Port portCopy = (Port)copyMap.get(port);
        Component compCounterpart = portCopy.getComponent();
        Component comp = port.getComponent();
        if (compCounterpart == null) {
            compCounterpart = (Component)copyMap.get(comp);
            if (compCounterpart == null) {
                compCounterpart = PortStaticImpl.createCounterPartComponent(comp);
            }
            compCounterpart.getConnectors().add((Object)portCopy);
        }
        if (!copyMap.containsKey(comp)) {
            copyMap.put((EObject)comp, (EObject)compCounterpart);
        }
        return compCounterpart;
    }

    public static Component obtainParent(Component comp, Map<EObject, EObject> copyMap) {
        Component compCopy = (Component)copyMap.get(comp);
        Component parentCounterpart = PortStaticImpl.getParentComp(compCopy);
        Component parent = PortStaticImpl.getParentComp(comp);
        if (parentCounterpart == null) {
            if (parent == null) {
                return null;
            }
            parentCounterpart = (Component)copyMap.get(parent);
            if (parentCounterpart == null) {
                parentCounterpart = PortStaticImpl.createCounterPartComponent(parent);
                copyMap.put((EObject)parent, (EObject)parentCounterpart);
            }
            compCopy.setContainer((IHierarchicElementContainer)parentCounterpart);
        }
        if (!copyMap.containsKey(parent)) {
            copyMap.put((EObject)parent, (EObject)parentCounterpart);
        }
        return parentCounterpart;
    }

    private static Component getParentComp(Component comp) {
        IHierarchicElementContainer parent = comp.getContainer();
        Component res = ComponentUtils.componentOf((EObject)parent);
        return comp.equals(res) ? null : res;
    }

    private static void copyChannel(Channel c, Map<EObject, EObject> copyMap, Component parent) {
        if (!copyMap.containsKey(c)) {
            Port src = (Port)copyMap.get(c.getSource());
            Port target = (Port)copyMap.get(c.getTarget());
            Channel newChannel = ComponentModelElementFactory.createChannelAndAttach(parent, c.getName(), src, target);
            newChannel.setComment(c.getComment());
            copyMap.put((EObject)c, (EObject)newChannel);
        }
    }
}

