/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.quality;

import java.util.Map;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.behavior.code.CodeSpecification;
import org.fortiss.af3.expression.model.terms.Const;
import org.fortiss.af3.expression.model.terms.EOperator;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.PredefinedFunction;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.Comment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.tooling.ext.quality.data.MetricKey;
import org.fortiss.tooling.ext.quality.data.MetricTreeNode;
import org.fortiss.tooling.ext.quality.service.IMetricProvider;
import org.fortiss.tooling.ext.quality.service.IModelQualityService;

public class ComponentMetricProvider
implements IMetricProvider<Component> {
    public void collectMetrics(MetricTreeNode node, Component comp) {
        CodeSpecification spec = comp.getCodeSpecification();
        if (spec == null) {
            return;
        }
        ComponentMetrics cm = new ComponentMetrics();
        this.visitStatement((IStatementTerm)spec.getBody(), cm);
        Map integers = node.getIntegerMetrics();
        IModelQualityService mqs = IModelQualityService.getInstance();
        MetricKey NUMBER_OF_TOTAL_CODE_CONSTANTS = mqs.getMetricKey("NUMBER_OF_TOTAL_CODE_CONSTANTS");
        MetricKey NUMBER_OF_TOTAL_CODE_CYCLOMATIC_COMPLEXITY = mqs.getMetricKey("NUMBER_OF_TOTAL_CODE_CYCLOMATIC_COMPLEXITY");
        MetricKey NUMBER_OF_TOTAL_CODE_COMMENTS = mqs.getMetricKey("NUMBER_OF_TOTAL_CODE_COMMENTS");
        MetricKey NUMBER_OF_TOTAL_CODE_LINES = mqs.getMetricKey("NUMBER_OF_TOTAL_CODE_LINES");
        integers.put(NUMBER_OF_TOTAL_CODE_CONSTANTS, cm.numberOfConstants);
        integers.put(NUMBER_OF_TOTAL_CODE_CYCLOMATIC_COMPLEXITY, cm.cyclomaticComplexity);
        integers.put(NUMBER_OF_TOTAL_CODE_COMMENTS, cm.numberOfComments);
        integers.put(NUMBER_OF_TOTAL_CODE_LINES, (int)spec.getBody().toString().chars().filter(ch -> ch == 10).count());
    }

    private void visitStatement(IStatementTerm term, ComponentMetrics metrics) {
        if (term != null) {
            if (term instanceof StatementSequence) {
                for (IStatementTerm stmt : ((StatementSequence)term).getStatements()) {
                    this.visitStatement(stmt, metrics);
                }
            } else if (term instanceof IfThenElse) {
                IfThenElse ifte = (IfThenElse)term;
                this.visitExpression(ifte.getGuard(), metrics);
                this.visitStatement((IStatementTerm)ifte.getThenBlock(), metrics);
                this.visitStatement((IStatementTerm)ifte.getElseBlock(), metrics);
                ++metrics.cyclomaticComplexity;
            } else if (term instanceof Assignment) {
                this.visitExpression(((Assignment)term).getValue(), metrics);
            } else if (!(term instanceof Return)) {
                if (term instanceof Comment) {
                    ++metrics.numberOfComments;
                } else {
                    throw new IllegalStateException("Statement Type Unsupported: " + String.valueOf(term.getClass()));
                }
            }
        }
    }

    private void visitExpression(IExpressionTerm expr, ComponentMetrics metrics) {
        if (expr != null) {
            if (expr instanceof Const) {
                ++metrics.numberOfConstants;
            } else if (expr instanceof FunctionCall) {
                PredefinedFunction preFunction;
                EOperator operator;
                FunctionCall function = (FunctionCall)expr;
                for (ITerm term : function.getArguments()) {
                    if (term instanceof IExpressionTerm) {
                        this.visitExpression((IExpressionTerm)term, metrics);
                        continue;
                    }
                    throw new IllegalStateException();
                }
                if (function.getFunction() instanceof PredefinedFunction && ((operator = (preFunction = (PredefinedFunction)function.getFunction()).getOperator()) == EOperator.AND || operator == EOperator.OR)) {
                    ++metrics.cyclomaticComplexity;
                }
            } else if (!(expr instanceof Var)) {
                throw new IllegalStateException();
            }
        }
    }

    private class ComponentMetrics {
        public int numberOfConstants;
        public int cyclomaticComplexity;
        public int numberOfComments;

        private ComponentMetrics() {
        }
    }
}

