/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.quality;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.tooling.ext.quality.data.MetricKey;
import org.fortiss.tooling.ext.quality.data.MetricTreeNode;
import org.fortiss.tooling.ext.quality.service.IMetricProvider;
import org.fortiss.tooling.ext.quality.service.IModelQualityService;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;

public class DataDictonaryMetricProvider
implements IMetricProvider<DataDictionary> {
    public void collectMetrics(MetricTreeNode dictNode, DataDictionary dataDict) {
        Map integers;
        for (FunctionDefinition function : dataDict.getFunctions()) {
            DataDictonaryMetricProvider.addCommonMetrics((EObject)function, (EObject)function.getFunction(), dictNode);
        }
        for (Enumeration enumeration : dataDict.getEnumerations()) {
            MetricTreeNode enumerationNode = DataDictonaryMetricProvider.addCommonMetrics((EObject)enumeration, (EObject)enumeration, dictNode);
            integers = enumerationNode.getIntegerMetrics();
            this.collectContainedElements(enumeration, (Map<MetricKey, Integer>)integers);
        }
        for (Array array : dataDict.getArrays()) {
            DataDictonaryMetricProvider.addCommonMetrics((EObject)array, (EObject)array, dictNode);
        }
        for (Structure structure : dataDict.getStructures()) {
            MetricTreeNode structureNode = DataDictonaryMetricProvider.addCommonMetrics((EObject)structure, (EObject)structure, dictNode);
            integers = structureNode.getIntegerMetrics();
            this.collectContainedElements(structure, (Map<MetricKey, Integer>)integers);
        }
    }

    private void collectContainedElements(Enumeration enumeration, Map<MetricKey, Integer> integers) {
        IModelQualityService mqs = IModelQualityService.getInstance();
        MetricKey NUMBER_OF_CONTAINED_ELEMENTS = mqs.getMetricKey("NUMBER_OF_CONTAINED_ELEMENTS");
        EList members = enumeration.getMembers();
        integers.put(NUMBER_OF_CONTAINED_ELEMENTS, members.size());
        this.collectCommentInformation(integers, (EList<? extends INamedCommentedElement>)members);
    }

    private void collectContainedElements(Structure structure, Map<MetricKey, Integer> integers) {
        IModelQualityService mqs = IModelQualityService.getInstance();
        MetricKey NUMBER_OF_CONTAINED_ELEMENTS = mqs.getMetricKey("NUMBER_OF_CONTAINED_ELEMENTS");
        EList members = structure.getMembers();
        integers.put(NUMBER_OF_CONTAINED_ELEMENTS, members.size());
        this.collectCommentInformation(integers, (EList<? extends INamedCommentedElement>)members);
    }

    private void collectCommentInformation(Map<MetricKey, Integer> integers, EList<? extends INamedCommentedElement> members) {
        IModelQualityService mqs = IModelQualityService.getInstance();
        MetricKey NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS = mqs.getMetricKey("NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS");
        MetricKey NUMBER_OF_TOTAL_COMMENTED_ELEMENTS = mqs.getMetricKey("NUMBER_OF_TOTAL_COMMENTED_ELEMENTS");
        int commentable = 0;
        int commented = 0;
        for (INamedCommentedElement element : members) {
            ++commentable;
            String comment = element.getComment();
            if (comment == null || comment == "") continue;
            ++commented;
        }
        integers.merge(NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS, commentable, Integer::sum);
        integers.merge(NUMBER_OF_TOTAL_COMMENTED_ELEMENTS, commented, Integer::sum);
    }

    private static MetricTreeNode addCommonMetrics(EObject constraintsObject, EObject object, MetricTreeNode parent) {
        IModelQualityService mqs = IModelQualityService.getInstance();
        MetricKey NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS = mqs.getMetricKey("NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS");
        MetricKey NUMBER_OF_TOTAL_COMMENTED_ELEMENTS = mqs.getMetricKey("NUMBER_OF_TOTAL_COMMENTED_ELEMENTS");
        MetricKey UNIQUE_ID = mqs.getMetricKey("UNIQUE_ID");
        MetricTreeNode metricNode = new MetricTreeNode();
        parent.getChildren().add(metricNode);
        mqs.getMetricData().getTreeNodeLookupTable().put(constraintsObject, metricNode);
        Map integers = metricNode.getIntegerMetrics();
        boolean isElementCommentable = object instanceof INamedCommentedElement;
        integers.put(NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS, isElementCommentable ? 1 : 0);
        String comment = isElementCommentable ? ((INamedCommentedElement)object).getComment() : null;
        integers.put(NUMBER_OF_TOTAL_COMMENTED_ELEMENTS, comment != null && comment != "" ? 1 : 0);
        if (isElementCommentable) {
            metricNode.setName(((INamedCommentedElement)object).getName());
        } else {
            metricNode.setName("Unnamable Element");
        }
        integers.put(UNIQUE_ID, object instanceof IIdLabeled ? ((IIdLabeled)object).getId() : -1);
        return metricNode;
    }
}

