/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.reuse;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.AF3ComponentActivator;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.ext.reuse.service.LayoutedReuseProviderBase;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsManipulation;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ComponentReuseProvider
extends LayoutedReuseProviderBase<Component> {
    public boolean updateReuseElement(Component componentToBeUpdated, Component componentAsUpdateSource) {
        ReuseLibraryUtilsManipulation.removeNonMatchingConnections((IHierarchicElement)componentToBeUpdated, (IHierarchicElement)componentAsUpdateSource, (Comparator)new PortMatchComparator());
        ComponentReuseProvider.updateRecursivelyAllPortTypes(componentAsUpdateSource, (EObject)componentToBeUpdated);
        return super.updateReuseElement((ILayoutedModelElement)componentToBeUpdated, (ILayoutedModelElement)componentAsUpdateSource);
    }

    public static void updateRecursivelyAllPortTypes(Component component, EObject contextElement) {
        ArrayList<String> invalidTypeDefWarnings = new ArrayList<String>();
        for (IConnector connector : component.getConnectors()) {
            List<String> warningsOfOneConnector = ComponentReuseProvider.updatePortType(connector, contextElement);
            invalidTypeDefWarnings.addAll(warningsOfOneConnector);
        }
        if (!invalidTypeDefWarnings.isEmpty()) {
            String warningMessage = "The following port type definitions could not be found and linked for component '" + component.getName() + "' (ID " + component.getId() + ").\n Please make sure to add or update them in the data dictionary.";
            warningMessage = warningMessage + "\n- " + String.join((CharSequence)"\n- ", invalidTypeDefWarnings);
            LoggingUtils.showWarning((String)warningMessage);
        }
        for (Component subComponent : component.getSubComponents()) {
            ComponentReuseProvider.updateRecursivelyAllPortTypes(subComponent, contextElement);
        }
    }

    private static List<String> updatePortType(IConnector connector, EObject contextElement) {
        ArrayList<String> invalidTypeDefWarnings = new ArrayList<String>();
        for (IModelElementSpecification spec : connector.getSpecifications()) {
            boolean isCorrectlySet;
            PortSpecification portSpec;
            IType type;
            if (!(spec instanceof PortSpecification) || !((type = (portSpec = (PortSpecification)spec).getType()) instanceof TDefinedType) || (isCorrectlySet = ComponentReuseProvider.findAndSetTypeDef((TDefinedType)type, contextElement))) continue;
            String portName = "unknown";
            String portId = "unknown";
            if (connector instanceof INamedElement) {
                portName = ((INamedElement)connector).getName();
            }
            if (connector instanceof IIdLabeled) {
                portId = String.valueOf(((IIdLabeled)connector).getId());
            }
            String definitionInfo = "Port '" + portName + "' with ID '" + portId + "' needs type definition '" + type.getTypeClassName() + "'.";
            String warningMessage = definitionInfo + "\nSuch a definition could not be found in the data dictionary. Make sure to update the data dictionary with the correct type.";
            LoggingUtils.warning((Plugin)AF3ComponentActivator.getDefault(), (String)warningMessage);
            invalidTypeDefWarnings.add(definitionInfo);
        }
        return invalidTypeDefWarnings;
    }

    private static boolean findAndSetTypeDef(TDefinedType definedType, EObject contextElement) {
        TypeDefinition currentDefinition = definedType.getDef();
        if (currentDefinition == null) {
            DataDictionary dict = (DataDictionary)KernelModelElementUtils.getRootElement((EObject)contextElement, DataDictionary.class);
            ITypeDefinition foundDefinition = dict.getDefinitionElement((IType)definedType);
            if (foundDefinition != null && foundDefinition instanceof TypeDefinition) {
                definedType.setDef((TypeDefinition)foundDefinition);
            } else {
                return false;
            }
        }
        return true;
    }

    private class PortMatchComparator
    implements Comparator<IConnector> {
        private PortMatchComparator() {
        }

        @Override
        public int compare(IConnector connector1, IConnector connector2) {
            if (connector1 == null || connector2 == null || !(connector1 instanceof Port) || !(connector2 instanceof Port)) {
                return -1;
            }
            Port port1 = (Port)connector1;
            Port port2 = (Port)connector2;
            int nameCompare = port1.getName().compareTo(port2.getName());
            if (nameCompare != 0) {
                return nameCompare;
            }
            int typeCompare = port1.getVariableType().getTypeClassName().compareTo(port2.getVariableType().getTypeClassName());
            if (typeCompare != 0) {
                return typeCompare;
            }
            int valueCompare = port1.getInitialValue().toString().compareTo(port2.getInitialValue().toString());
            return valueCompare;
        }
    }
}

