/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.simulator;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.simulator.ExecutionException;
import org.fortiss.af3.component.simulator.SignalSource;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;

public abstract class ExecutableAtomicComponentBase<S extends IModelElementSpecification>
extends ExecutableComponent<S> {
    protected final boolean isWeaklyCausal;
    private Map<OutputPort, Term<? extends ITerm>> externalOutputValues = new HashMap<OutputPort, Term<? extends ITerm>>();
    protected Deque<Map<OutputPort, Term<? extends ITerm>>> externalOutputValuesHistory = new LinkedList<Map<OutputPort, Term<? extends ITerm>>>();
    public Map<Var, DataStateVariable> dataStateVariables = new HashMap<Var, DataStateVariable>();
    public Deque<Map<Var, DataStateVariable>> dataStateVariablesHistory = new LinkedList<Map<Var, DataStateVariable>>();
    protected Map<InputPort, Var> inputPortVariables = new HashMap<InputPort, Var>();
    protected Deque<HashMap<InputPort, Var>> inputPortVariablesHistory = new LinkedList<HashMap<InputPort, Var>>();
    protected Map<OutputPort, Var> outputPortVariables = new HashMap<OutputPort, Var>();
    protected Deque<HashMap<OutputPort, Var>> outputPortVariablesHistory = new LinkedList<HashMap<OutputPort, Var>>();

    public ExecutableAtomicComponentBase(S specification) {
        this(specification, new ArrayList());
    }

    public ExecutableAtomicComponentBase(S specification, List<ExecutableComponent<?>> subExecutables) {
        this(ComponentArchitectureUtils.getProperParentComponent(specification), specification, subExecutables);
    }

    public ExecutableAtomicComponentBase(Component comp, S specification, List<ExecutableComponent<?>> subExecutables) {
        super(comp, specification, subExecutables);
        this.isWeaklyCausal = !this.modelElement.isStronglyCausal();
        for (Port port : this.modelElement.getInputPorts()) {
            this.inputPortVariables.put((InputPort)port, VarStaticImpl.create((String)port.getName()));
        }
        for (Port port : this.modelElement.getOutputPorts()) {
            this.outputPortVariables.put((OutputPort)port, VarStaticImpl.create((String)port.getName()));
        }
    }

    protected abstract void doAtomicStep();

    @Override
    public void initialize() {
        super.initialize();
        for (OutputPort op : this.modelElement.getOutputPorts()) {
            this.setCurrentOutputValue(op, (Term<ITerm>)NoVal.NOVAL);
            if (this.isWeaklyCausal) continue;
            IExpressionTerm initialValue = op.getInitialValue();
            this.setInternalOutputValue(op, this.getTermValue((ITerm)initialValue));
        }
    }

    @Override
    public void backupState() {
        super.backupState();
        this.outputPortVariablesHistory.addLast(new HashMap<OutputPort, Var>(this.outputPortVariables));
        this.inputPortVariablesHistory.addLast(new HashMap<InputPort, Var>(this.inputPortVariables));
        this.externalOutputValuesHistory.addLast(new HashMap<OutputPort, Term<? extends ITerm>>(this.externalOutputValues));
        this.dataStateVariablesHistory.addLast(new HashMap<Var, DataStateVariable>(this.dataStateVariables));
    }

    @Override
    protected void doPreStep() {
        if (!this.isWeaklyCausal) {
            for (OutputPort out : this.modelElement.getOutputPorts()) {
                this.setCurrentOutputValue(out, this.getInternalOutputValue(out));
            }
        }
    }

    @Override
    protected void doStep() {
        for (OutputPort out : this.modelElement.getOutputPorts()) {
            this.setInternalOutputValue(out, (Term<ITerm>)NoVal.NOVAL);
        }
        for (InputPort p : this.getModelElement().getInputPorts()) {
            if (!this.selfInitialize && this.getParentExecutable() != null && (!p.getIncoming().isEmpty() || this.parentHandlesUnconnected(p))) continue;
            if (this.externallySet.contains(p)) {
                this.setCurrentInputValue(p, (Term<ITerm>)((Term)this.internalState.get(p)));
                if (this.isSignalOnHold(p)) continue;
                this.internalState.put(p, NoVal.NOVAL);
                continue;
            }
            if (this.isSignalOnHold(p)) {
                this.setCurrentInputValue(p, (Term<ITerm>)((Term)this.internalState.get(p)));
                continue;
            }
            this.internalState.put(p, NoVal.NOVAL);
            this.setCurrentInputValue(p, (Term<ITerm>)NoVal.NOVAL);
        }
        this.externallySet.clear();
        this.prepareEvaluationContextWithCurrentInput();
        try {
            this.doAtomicStep();
        }
        catch (Exception ex) {
            throw new ExecutionException("Error during simulation of atomic component \"" + this.modelElement.getName() + "\": " + ex.getMessage(), ex);
        }
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.outputPortVariables = this.outputPortVariablesHistory.removeLast();
        this.inputPortVariables = this.inputPortVariablesHistory.removeLast();
        this.externalOutputValues = this.externalOutputValuesHistory.removeLast();
        this.dataStateVariables = this.dataStateVariablesHistory.removeLast();
    }

    @Override
    protected void doStepBack() {
        this.restoreState();
    }

    @Override
    public void clearHistory() {
        this.outputPortVariablesHistory.clear();
        this.inputPortVariablesHistory.clear();
        this.externalOutputValuesHistory.clear();
        this.dataStateVariablesHistory.clear();
        this.dataStateVariables.clear();
        super.clearHistory();
    }

    protected void prepareEvaluationContextWithCurrentInput() {
        for (InputPort port : this.inputPortVariables.keySet()) {
            this.evaluationContext.setValue((VarBase)this.inputPortVariables.get(port), this.getCurrentInputValue(port));
        }
    }

    @Override
    public void setHoldSignal(Port port, boolean holdValue) {
        super.setHoldSignal(port, holdValue);
        if (port instanceof InputPort && this.getModelElement().getInputPorts().contains((Object)port)) {
            if (!holdValue) {
                this.internalState.put(port, NoVal.NOVAL);
            } else if (!this.externallySet.contains(port)) {
                this.internalState.put(port, this.getCurrentInputValue((InputPort)port));
            }
        }
    }

    @Override
    public void setCurrentOutputValue(OutputPort port, Term<? extends ITerm> value) {
        if (this.isWeaklyCausal) {
            this.setInternalOutputValue(port, value);
        } else {
            this.externalOutputValues.put(port, value);
        }
    }

    @Override
    public Term<? extends ITerm> getCurrentOutputValue(OutputPort port) {
        if (this.isWeaklyCausal) {
            return this.getInternalOutputValue(port);
        }
        return this.externalOutputValues.get(port);
    }

    @Override
    public Term<? extends ITerm> getNextInputValue(InputPort port) {
        SignalSource source = this.findInputPortSignalSource(port);
        if (source.equals(this, port)) {
            return (Term)this.internalState.get(port);
        }
        return source.getExecutable().getNextValue(source.getPort());
    }

    @Override
    public Term<? extends ITerm> getNextOutputValue(OutputPort port) {
        if (this.isWeaklyCausal) {
            return null;
        }
        return this.getInternalOutputValue(port);
    }

    public Term<? extends ITerm> getInternalOutputValue(OutputPort port) {
        return this.evaluationContext.getValue((VarBase)this.outputPortVariables.get(port));
    }

    public void setInternalOutputValue(OutputPort port, Term<? extends ITerm> value) {
        this.evaluationContext.setValue((VarBase)this.outputPortVariables.get(port), value);
    }

    @Override
    public Term<? extends ITerm> getCurrentInputValue(InputPort port) {
        SignalSource source = this.findInputPortSignalSource(port);
        if (source.equals(this, port)) {
            return this.evaluationContext.getValue((VarBase)this.inputPortVariables.get(port));
        }
        return source.getExecutable().getCurrentValue(source.getPort());
    }

    @Override
    public void setCurrentInputValue(InputPort port, Term<? extends ITerm> value) {
        SignalSource source = this.findInputPortSignalSource(port);
        if (source.equals(this, port)) {
            this.evaluationContext.setValue((VarBase)this.inputPortVariables.get(port), value);
        } else {
            source.getExecutable().setCurrentValue(source.getPort(), value);
        }
    }

    @Override
    public void setNextInputValue(InputPort port, Term<? extends ITerm> value) {
        SignalSource source = this.findInputPortSignalSource(port);
        if (source.equals(this, port)) {
            this.internalState.put(port, value);
            this.externallySet.add(port);
        } else {
            source.getExecutable().setNextValue(source.getPort(), value);
        }
    }

    @Override
    public void setNextOutputValue(OutputPort port, Term<? extends ITerm> value) {
        this.setInternalOutputValue(port, value);
    }

    @Override
    public SignalSource findInputPortSignalSource(InputPort inputPort) {
        if (this.getParentExecutable() == null || inputPort.getIncoming().isEmpty() && !this.parentHandlesUnconnected(inputPort)) {
            return new SignalSource(this, inputPort);
        }
        return this.getParentExecutable().findInputPortSignalSource(inputPort);
    }

    @Override
    public SignalSource findOutputPortSignalSource(OutputPort outputPort) {
        return new SignalSource(this, outputPort);
    }
}

