/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.simulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.simulator.ITraceListener;
import org.fortiss.af3.component.simulator.SignalSource;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.ITypeSystem;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.services.ITypeSystemService;
import org.fortiss.af3.project.typesystem.IEvaluationContext;
import org.fortiss.af3.project.typesystem.ITermEvaluator;
import org.fortiss.af3.project.typesystem.ITypeChecker;
import org.fortiss.af3.project.typesystem.ITypeSystemCompiler;
import org.fortiss.af3.project.typesystem.ITypeSystemHandler;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;

public abstract class ExecutableComponent<S extends IModelElementSpecification> {
    protected List<ExecutableComponent<?>> subExecutables;
    protected ExecutableComponent<? extends IModelElementSpecification> parentExecutable;
    protected Map<EObject, Object> internalState = new HashMap<EObject, Object>();
    protected final Deque<HashMap<EObject, Object>> internalStateHistory = new LinkedList<HashMap<EObject, Object>>();
    protected Map<Port, Term<? extends ITerm>> externalState = new HashMap<Port, Term<? extends ITerm>>();
    protected Deque<HashMap<Port, Term<? extends ITerm>>> externalStateHistory = new LinkedList<HashMap<Port, Term<? extends ITerm>>>();
    protected Set<InputPort> externallySet = new HashSet<InputPort>();
    protected Deque<HashSet<InputPort>> externallySetHistory = new LinkedList<HashSet<InputPort>>();
    protected Map<EObject, Object> extendedData = new HashMap<EObject, Object>();
    protected Deque<HashMap<EObject, Object>> extendedDataHistory = new LinkedList<HashMap<EObject, Object>>();
    protected final Component modelElement;
    protected final S specification;
    protected final ITermEvaluator termEvaluator;
    protected final ITypeSystemCompiler termCompiler;
    protected final ITypeChecker typeChecker;
    protected IEvaluationContext evaluationContext;
    protected Deque<IEvaluationContext> evaluationContextHistory = new LinkedList<IEvaluationContext>();
    protected List<ITraceListener> listeners = new ArrayList<ITraceListener>();
    protected boolean selfInitialize = false;

    public ExecutableComponent(Component modelElement, List<ExecutableComponent<?>> subExecutables) {
        this(modelElement, null, subExecutables);
    }

    public ExecutableComponent(Component modelElement, S specification, List<ExecutableComponent<?>> subExecutables) {
        Assert.isNotNull((Object)modelElement);
        this.modelElement = modelElement;
        this.specification = specification;
        this.termEvaluator = ITypeSystemService.INSTANCE.getHandler((EObject)modelElement).getTermEvaluator();
        this.termCompiler = ITypeSystemService.INSTANCE.getHandler((EObject)modelElement).getTypeSystemCompiler();
        this.typeChecker = ITypeSystemService.INSTANCE.getHandler((EObject)modelElement).getTypeChecker();
        this.evaluationContext = ITypeSystemService.INSTANCE.createEvaluationContext((EObject)modelElement);
        this.subExecutables = subExecutables;
        for (ExecutableComponent<?> subExec : subExecutables) {
            subExec.setParentExecutable(this);
        }
    }

    public ExecutableComponent(Component modelElement, S specification, List<ExecutableComponent<?>> subExecutables, ITypeSystemHandler<? extends ITypeSystem> handler) {
        Assert.isNotNull((Object)modelElement);
        this.modelElement = modelElement;
        this.specification = specification;
        this.termEvaluator = handler.getTermEvaluator();
        this.termCompiler = handler.getTypeSystemCompiler();
        this.typeChecker = handler.getTypeChecker();
        this.evaluationContext = handler.createEvaluationContext((EObject)modelElement);
        this.subExecutables = subExecutables;
        for (ExecutableComponent<?> subExec : subExecutables) {
            subExec.setParentExecutable(this);
        }
    }

    public Term<? extends ITerm> getCurrentVariableValue(DataStateVariable dsv) {
        return this.evaluationContext.getValue((VarBase)dsv.getVariable());
    }

    public Component getModelElement() {
        return this.modelElement;
    }

    public S getSpecification() {
        return this.specification;
    }

    public void setSelfInitialize(boolean selfInitialize) {
        this.selfInitialize = selfInitialize;
    }

    protected void setParentExecutable(ExecutableComponent<?> parent) {
        this.parentExecutable = parent;
    }

    public ExecutableComponent<? extends IModelElementSpecification> getParentExecutable() {
        return this.parentExecutable;
    }

    public ITerm compileToITerm(String value) {
        try {
            return this.termCompiler.compileTerm(value, (EObject)this.modelElement);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ITypeChecker getTypeChecker() {
        return this.typeChecker;
    }

    public final Term<? extends ITerm> getTermValue(ITerm term) {
        if (term == null) {
            return NoVal.NOVAL;
        }
        return this.termEvaluator.evaluate(term, this.evaluationContext);
    }

    public String toString() {
        return this.modelElement.getName();
    }

    public void setCurrentInputValue(InputPort ip, ITerm value) {
        this.setCurrentInputValue(ip, this.getTermValue(value));
    }

    public void setCurrentOutputValue(OutputPort op, ITerm value) {
        this.setCurrentOutputValue(op, this.getTermValue(value));
    }

    public final Term<? extends ITerm> getCurrentValue(Port port) {
        if (port instanceof OutputPort) {
            return this.getCurrentOutputValue((OutputPort)port);
        }
        return this.getCurrentInputValue((InputPort)port);
    }

    public final void setCurrentValue(Port port, Term<? extends ITerm> value) {
        if (port instanceof OutputPort) {
            this.setCurrentOutputValue((OutputPort)port, value);
        } else {
            this.setCurrentInputValue((InputPort)port, value);
        }
    }

    public abstract Term<? extends ITerm> getCurrentInputValue(InputPort var1);

    public abstract void setCurrentInputValue(InputPort var1, Term<? extends ITerm> var2);

    public abstract Term<? extends ITerm> getCurrentOutputValue(OutputPort var1);

    public abstract void setCurrentOutputValue(OutputPort var1, Term<? extends ITerm> var2);

    public void setNextInputValue(InputPort ip, ITerm value) {
        this.setNextInputValue(ip, this.getTermValue(value));
    }

    public void setNextOutputValue(OutputPort op, ITerm value) {
        this.setNextOutputValue(op, this.getTermValue(value));
    }

    public final Term<? extends ITerm> getNextValue(Port port) {
        if (port instanceof OutputPort) {
            return this.getNextOutputValue((OutputPort)port);
        }
        return this.getNextInputValue((InputPort)port);
    }

    public final void setNextValue(Port port, Term<? extends ITerm> value) {
        if (port instanceof OutputPort) {
            this.setNextOutputValue((OutputPort)port, value);
        } else {
            this.setNextInputValue((InputPort)port, value);
        }
    }

    public abstract Term<? extends ITerm> getNextInputValue(InputPort var1);

    public abstract void setNextInputValue(InputPort var1, Term<? extends ITerm> var2);

    public abstract Term<? extends ITerm> getNextOutputValue(OutputPort var1);

    public abstract void setNextOutputValue(OutputPort var1, Term<? extends ITerm> var2);

    public Object getInternalValue(EObject modelElement) {
        return this.internalState.get(modelElement);
    }

    public Term<? extends ITerm> getNextVariableValue(DataStateVariable dsv) {
        return (Term)this.getInternalValue((EObject)dsv);
    }

    public void setInternalValue(EObject modelElement, Object value) {
        this.internalState.put(modelElement, value);
    }

    protected boolean parentHandlesUnconnected(InputPort port) {
        return false;
    }

    protected SignalSource handleUnconnectedInputPortSignalSearch(InputPort inputPort) {
        return this.getParentExecutable().findInputPortSignalSource(inputPort);
    }

    public void initialize() {
        for (InputPort ip : this.modelElement.getInputPorts()) {
            if (!this.selfInitialize && this.getParentExecutable() != null && (!ip.getIncoming().isEmpty() || this.parentHandlesUnconnected(ip))) continue;
            IExpressionTerm initialValue = ip.getInitialValue();
            this.setNextInputValue(ip, this.getTermValue((ITerm)initialValue));
        }
    }

    protected void doPreStep() {
    }

    protected abstract void doStep();

    protected void doPostStep() {
    }

    public void performStep() {
        this.doPreStep();
        this.doStep();
        this.doPostStep();
    }

    protected abstract void doStepBack();

    public void performStepBack() {
        this.restoreState();
        this.doStepBack();
    }

    public void clearHistory() {
        this.evaluationContext.clear();
        this.evaluationContextHistory.clear();
        this.internalStateHistory.clear();
        this.extendedDataHistory.clear();
        this.externalStateHistory.clear();
        this.externallySetHistory.clear();
    }

    public void clearInputs() {
        for (InputPort port : this.modelElement.getInputPorts()) {
            this.setCurrentInputValue(port, (Term<ITerm>)NoVal.NOVAL);
        }
    }

    public final void setExtendedData(EObject element, Object data) {
        this.extendedData.put(element, data);
    }

    public final Object getExtendedData(EObject element) {
        return this.extendedData.get(element);
    }

    public void setHoldSignal(Port port, boolean holdValue) {
        SignalSource source = this.findSignalSourceExecutable(port);
        source.getExecutable().setExtendedData((EObject)source.getPort(), holdValue);
    }

    public final boolean isSignalOnHold(Port port) {
        SignalSource source = this.findSignalSourceExecutable(port);
        Boolean b = (Boolean)source.getExecutable().getExtendedData((EObject)source.getPort());
        return b != null && b != false;
    }

    public final void setSignal(Port port, Term<? extends ITerm> value) {
        SignalSource source = this.findSignalSourceExecutable(port);
        if (source != null) {
            if (source.getPort() instanceof OutputPort) {
                source.getExecutable().setCurrentOutputValue((OutputPort)source.getPort(), value);
            } else if (source.getPort() instanceof InputPort) {
                source.getExecutable().setCurrentInputValue((InputPort)source.getPort(), value);
            }
        }
    }

    public List<ExecutableComponent<? extends IModelElementSpecification>> getSubElements() {
        return Collections.emptyList();
    }

    public final ExecutableComponent<?> findExecutable(EObject element) {
        return this.findExecutable(element, false);
    }

    public final ExecutableComponent<?> findExecutable(EObject element, boolean recursive) {
        if (this.getModelElement() == element) {
            return this;
        }
        for (ExecutableComponent<IModelElementSpecification> exec : this.getSubElements()) {
            ExecutableComponent<?> res;
            if (exec.getModelElement() == element) {
                return exec;
            }
            if (!recursive || (res = exec.findExecutable(element, true)) == null) continue;
            return res;
        }
        return null;
    }

    public final ExecutableComponent<?> findSimilarExecutable(EObject element) {
        if (element instanceof Component && this.getModelElement().getId() == ((Component)element).getId()) {
            return this;
        }
        for (ExecutableComponent<IModelElementSpecification> exec : this.getSubElements()) {
            if (element instanceof Component && exec.getModelElement().getId() == ((Component)element).getId()) {
                return exec;
            }
            ExecutableComponent<?> res = exec.findSimilarExecutable(element);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public final SignalSource findSignalSourceExecutable(Port signal) {
        if (signal instanceof OutputPort) {
            return this.findOutputPortSignalSource((OutputPort)signal);
        }
        if (signal instanceof InputPort) {
            return this.findInputPortSignalSource((InputPort)signal);
        }
        return null;
    }

    public abstract SignalSource findInputPortSignalSource(InputPort var1);

    public abstract SignalSource findOutputPortSignalSource(OutputPort var1);

    public void addTraceListener(ITraceListener listener) {
        this.listeners.add(listener);
    }

    public void removeTraceListener(ITraceListener listener) {
        this.listeners.remove(listener);
    }

    public void backupState() {
        this.evaluationContextHistory.addLast(this.evaluationContext.cloneContext());
        this.internalStateHistory.addLast(new HashMap<EObject, Object>(this.internalState));
        this.extendedDataHistory.addLast(new HashMap<EObject, Object>(this.extendedData));
        this.externalStateHistory.addLast(new HashMap<Port, Term<? extends ITerm>>(this.externalState));
        this.externallySetHistory.addLast(new HashSet<InputPort>(this.externallySet));
    }

    public void restoreState() {
        this.evaluationContext = this.evaluationContextHistory.removeLast();
        this.internalState = this.internalStateHistory.removeLast();
        this.extendedData = this.extendedDataHistory.removeLast();
        this.externalState = this.externalStateHistory.removeLast();
        this.externallySet = this.externallySetHistory.removeLast();
    }
}

