/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.simulator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.simulator.SignalSource;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;

public class ExecutableCompositeComponent
extends ExecutableComponent<IModelElementSpecification> {
    protected List<Component> linearization;
    protected Map<Component, ExecutableComponent<?>> linearizationCache = new HashMap();
    protected Map<Port, Port> portProjection = new HashMap<Port, Port>();

    public ExecutableCompositeComponent(Component component, List<ExecutableComponent<?>> subExecutables) {
        super(component, null, subExecutables);
        for (Channel ch : this.modelElement.getChannels()) {
            this.portProjection.put(ch.getTarget(), ch.getSource());
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isTransparentCompositeDuringStep()) {
            this.linearization = null;
        } else {
            this.prepareLinearization();
        }
        for (OutputPort op : this.modelElement.getOutputPorts()) {
            if (!op.getIncoming().isEmpty()) continue;
            this.setCurrentOutputValue(op, (Term<? extends ITerm>)NoVal.NOVAL);
        }
        for (ExecutableComponent sub : this.subExecutables) {
            sub.initialize();
        }
    }

    public boolean isTransparentCompositeDuringStep() {
        return this.parentExecutable instanceof ExecutableCompositeComponent;
    }

    private void prepareLinearization() {
        this.linearization = this.getModelElement().createLinearization();
        this.linearizationCache.clear();
        for (Component c : this.linearization) {
            ExecutableComponent<?> exec = this.findExecutable((EObject)c, true);
            Assert.isNotNull(exec);
            this.linearizationCache.put(c, exec);
        }
    }

    @Override
    public void backupState() {
        super.backupState();
        for (ExecutableComponent subExec : this.subExecutables) {
            subExec.backupState();
        }
    }

    @Override
    public void restoreState() {
        for (ExecutableComponent subExec : this.subExecutables) {
            subExec.restoreState();
        }
        super.restoreState();
    }

    @Override
    protected void doPreStep() {
        for (InputPort p : this.getModelElement().getInputPorts()) {
            if (!this.selfInitialize && this.getParentExecutable() != null && (!p.getIncoming().isEmpty() || this.parentHandlesUnconnected(p))) continue;
            if (this.externallySet.contains(p) || p.getIncoming().isEmpty()) {
                this.setCurrentInputValue(p, (Term<? extends ITerm>)((Term)this.internalState.get(p)));
                if (this.isSignalOnHold(p)) continue;
                this.internalState.put(p, NoVal.NOVAL);
                continue;
            }
            if (this.isSignalOnHold(p)) {
                this.setCurrentInputValue(p, (Term<? extends ITerm>)((Term)this.internalState.get(p)));
                continue;
            }
            this.internalState.put(p, NoVal.NOVAL);
            this.setCurrentInputValue(p, (Term<? extends ITerm>)NoVal.NOVAL);
        }
        this.externallySet.clear();
        for (ExecutableComponent subExec : this.subExecutables) {
            subExec.doPreStep();
        }
    }

    @Override
    protected void doStep() {
        if (this.linearization != null) {
            for (Component linComp : this.linearization) {
                this.linearizationCache.get(linComp).doStep();
            }
        }
    }

    @Override
    public void performStepBack() {
        if (this.linearization != null) {
            for (Component linComp : this.linearization) {
                this.linearizationCache.get(linComp).performStepBack();
            }
        }
    }

    @Override
    public List<ExecutableComponent<?>> getSubElements() {
        return this.subExecutables;
    }

    @Override
    public void setHoldSignal(Port port, boolean holdValue) {
        super.setHoldSignal(port, holdValue);
        if (port instanceof InputPort && this.getModelElement().getInputPorts().contains((Object)port)) {
            if (!holdValue) {
                this.internalState.put(port, NoVal.NOVAL);
            } else if (!this.externallySet.contains(port)) {
                this.internalState.put(port, this.getCurrentInputValue((InputPort)port));
            }
        }
    }

    @Override
    public Term<? extends ITerm> getCurrentInputValue(InputPort port) {
        SignalSource source = this.findInputPortSignalSource(port);
        if (source.equals(this, port)) {
            return (Term)this.externalState.get(port);
        }
        return source.getExecutable().getCurrentValue(source.getPort());
    }

    @Override
    public void setCurrentInputValue(InputPort port, Term<? extends ITerm> value) {
        SignalSource source = this.findInputPortSignalSource(port);
        if (source.equals(this, port)) {
            this.externalState.put(port, value);
        } else {
            source.getExecutable().setCurrentValue(source.getPort(), value);
        }
    }

    @Override
    public Term<? extends ITerm> getCurrentOutputValue(OutputPort port) {
        SignalSource source = this.findOutputPortSignalSource(port);
        if (source.equals(this, port)) {
            return (Term)this.externalState.get(port);
        }
        return source.getExecutable().getCurrentValue(source.getPort());
    }

    @Override
    public void setCurrentOutputValue(OutputPort port, Term<? extends ITerm> value) {
        SignalSource pair = this.findOutputPortSignalSource(port);
        if (pair.equals(this, port)) {
            this.externalState.put(port, value);
        } else {
            pair.getExecutable().setCurrentValue(pair.getPort(), value);
        }
    }

    @Override
    public SignalSource findInputPortSignalSource(InputPort inputPort) {
        if (inputPort.getComponent() == this.getModelElement()) {
            if (this.getParentExecutable() == null || inputPort.getIncoming().isEmpty() && !this.parentHandlesUnconnected(inputPort)) {
                return new SignalSource(this, inputPort);
            }
            return this.handleUnconnectedInputPortSignalSearch(inputPort);
        }
        Port source = this.portProjection.get(inputPort);
        if (source instanceof InputPort) {
            return this.findInputPortSignalSource((InputPort)source);
        }
        if (source instanceof OutputPort) {
            return this.findExecutable((EObject)source.getComponent()).findOutputPortSignalSource((OutputPort)source);
        }
        return this.findExecutable((EObject)inputPort.getComponent()).findInputPortSignalSource(inputPort);
    }

    @Override
    public SignalSource findOutputPortSignalSource(OutputPort outputPort) {
        if (outputPort.getIncoming().isEmpty()) {
            return new SignalSource(this, outputPort);
        }
        Port source = this.portProjection.get(outputPort);
        return this.findExecutable((EObject)source.getComponent()).findOutputPortSignalSource((OutputPort)source);
    }

    @Override
    public Term<? extends ITerm> getNextInputValue(InputPort port) {
        SignalSource source = this.findInputPortSignalSource(port);
        if (source.equals(this, port)) {
            return (Term)this.internalState.get(port);
        }
        return source.getExecutable().getNextValue(source.getPort());
    }

    @Override
    public void setNextInputValue(InputPort port, Term<? extends ITerm> value) {
        SignalSource source = this.findInputPortSignalSource(port);
        if (source.equals(this, port)) {
            this.internalState.put(port, value);
            this.externallySet.add(port);
        } else {
            source.getExecutable().setNextValue(source.getPort(), value);
        }
    }

    @Override
    public Term<? extends ITerm> getNextOutputValue(OutputPort port) {
        SignalSource source = this.findOutputPortSignalSource(port);
        if (source.equals(this, port)) {
            return (Term)this.externalState.get(port);
        }
        return source.getExecutable().getNextValue(source.getPort());
    }

    @Override
    public void setNextOutputValue(OutputPort port, Term<? extends ITerm> value) {
        SignalSource source = this.findOutputPortSignalSource(port);
        if (source.equals(this, port)) {
            this.externalState.put(port, value);
        } else {
            source.getExecutable().setNextValue(source.getPort(), value);
        }
    }

    @Override
    public void clearHistory() {
        super.clearHistory();
    }

    @Override
    protected void doStepBack() {
    }
}

