/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.simulator.transform;

import java.util.ArrayList;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.simulator.ExecutableCompositeComponent;
import org.fortiss.af3.component.simulator.transform.ExecutableComponentTransformationBase;
import org.fortiss.af3.component.simulator.transform.MissingComponentBehaviorTransformation;
import org.fortiss.af3.project.extension.data.ExecutionConfigTransformationContext;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;

public class ExecutableCompositeComponentTransformation
extends ExecutableComponentTransformationBase {
    public boolean canHandleChainTransformation(Class<?> sourceClass, ITransformationContext context) {
        if (!(context instanceof ExecutionConfigTransformationContext)) {
            return false;
        }
        return Component.class.isAssignableFrom(sourceClass) || ComponentArchitecture.class.isAssignableFrom(sourceClass);
    }

    public boolean canTransform(Object source, ITransformationContext context) {
        if (source instanceof ComponentArchitecture) {
            source = ((ComponentArchitecture)source).getTopComponent();
        }
        return source instanceof Component && ((Component)source).getContainedElements().size() > 0;
    }

    public Object transform(Object source, ITransformationContext context) throws TransformationFailedException {
        if (source instanceof ComponentArchitecture) {
            source = ((ComponentArchitecture)source).getTopComponent();
        }
        Component sourceComponent = (Component)source;
        ArrayList subExecutables = new ArrayList();
        for (Component subComponent : sourceComponent.getSubComponents()) {
            ExecutableComponent<? extends IModelElementSpecification> subExecutable = this.createExecutableForComponent(subComponent, context);
            if (subExecutable != null) {
                subExecutables.add(subExecutable);
                continue;
            }
            throw new MissingComponentBehaviorTransformation(this, subExecutables);
        }
        return new ExecutableCompositeComponent(sourceComponent, subExecutables);
    }
}

