/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationModelElementFactory;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.component.utils.IComponentArchitectureTransformation;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public abstract class ComponentArchitectureTransformationBase<A extends IHierarchicElement & IProjectRootElement, T extends AllocationTable, E extends IHierarchicElement, I extends EntryConnectorBase, O extends ExitConnectorBase, C extends IConnection, AE extends AllocationEntry, AI extends AllocationEntry, AO extends AllocationEntry>
implements IComponentArchitectureTransformation<A> {
    protected static final String LEFT_ARROW = "\u2192";
    private Class<AE> entityAllocationType;
    private Class<AI> inputPortAllocationType;
    private Class<AO> outputPortAllocationType;

    protected ComponentArchitectureTransformationBase(Class<AE> entityAllocationType, Class<AI> inputPortAllocationType, Class<AO> outputPortAllocationType) {
        this.entityAllocationType = entityAllocationType;
        this.inputPortAllocationType = inputPortAllocationType;
        this.outputPortAllocationType = outputPortAllocationType;
    }

    private void searchComponents(Component component, List<Component> leafComponents, List<Component> result) {
        if (leafComponents.contains(component) || ComponentArchitectureUtils.isAtomicComponent(component)) {
            result.add(component);
            return;
        }
        for (Component childComponent : EcoreUtils.pickInstanceOf(Component.class, (List)component.eContents())) {
            this.searchComponents(childComponent, leafComponents, result);
        }
    }

    protected List<OutputPort> getComponentOutputPorts(InputPort inputPort, List<Component> components) {
        if (inputPort.getIncomingChannels().isEmpty()) {
            return Collections.emptyList();
        }
        Channel channel = (Channel)inputPort.getIncomingChannels().get(0);
        Component sourceComp = channel.getSource().getComponent();
        while (!components.contains(sourceComp)) {
            EList<Channel> incomingChannels = channel.getSource().getIncomingChannels();
            if (incomingChannels.isEmpty()) {
                return Collections.emptyList();
            }
            channel = (Channel)incomingChannels.get(0);
            sourceComp = channel.getSource().getComponent();
        }
        if (sourceComp != null && components.contains(sourceComp)) {
            return Collections.singletonList((OutputPort)channel.getSource());
        }
        return Collections.emptyList();
    }

    private I createEntityInputPort(E entity, InputPort inputPort, T caAlloc) {
        I entityInputPort = this.createEntityInputPort(inputPort);
        AllocationUtils.addAllocationEntry(caAlloc, this.inputPortAllocationType, (IModelElement)inputPort, entityInputPort);
        entity.getConnectors().add(entityInputPort);
        return entityInputPort;
    }

    private O createEntityOutputPort(E entity, OutputPort outputPort, T caAlloc) {
        O entityOutputPort = this.createEntityOutputPort(outputPort);
        AllocationUtils.addAllocationEntry(caAlloc, this.outputPortAllocationType, (IModelElement)outputPort, entityOutputPort);
        entity.getConnectors().add(entityOutputPort);
        return entityOutputPort;
    }

    @Override
    public final A transform(Component topLevelComponent, List<Component> leafComponents, AllocationTableCollection atc) {
        boolean hasModelContext;
        A arch = this.createEntityArchitecture(topLevelComponent);
        ArrayList<Component> components = new ArrayList<Component>();
        this.searchComponents(topLevelComponent, leafComponents, components);
        ComponentArchitecture componentArchitecture = (ComponentArchitecture)KernelModelElementUtils.getParentElement((EObject)topLevelComponent, ComponentArchitecture.class, (boolean)false);
        FileProject fileProject = (FileProject)EcoreUtils.getFirstParentWithType((EObject)topLevelComponent, FileProject.class);
        boolean bl = hasModelContext = IPersistencyService.getInstance().getTopLevelElementFor((EObject)fileProject) != null;
        if (atc == null) {
            atc = AllocationModelElementFactory.createAllocationTableCollection((String)"Allocations");
            if (hasModelContext) {
                IElementCompositorService.getInstance().compose((EObject)fileProject, (EObject)atc, null);
            } else {
                fileProject.getRootElements().add((Object)atc);
            }
        }
        T caAlloc = this.createAllocationTable(arch, componentArchitecture, atc);
        caAlloc.setSourceView((IProjectRootElement)componentArchitecture);
        caAlloc.setTargetView((IProjectRootElement)arch);
        atc.getContainedElements().add(caAlloc);
        for (Component comp : components) {
            E entity = this.createEntity(comp);
            AllocationUtils.addAllocationEntry(caAlloc, this.entityAllocationType, (IModelElement)comp, entity);
            for (InputPort inputPort : comp.getInputPorts()) {
                this.createEntityInputPort(entity, inputPort, caAlloc);
            }
            for (OutputPort outputPort : comp.getOutputPorts()) {
                this.createEntityOutputPort(entity, outputPort, caAlloc);
            }
            arch.getContainedElements().add(entity);
        }
        HashMap<String, Integer> portNumberMap = new HashMap<String, Integer>();
        HashMap<String, String> portNameMap = new HashMap<String, String>();
        for (Component targetComp : components) {
            for (InputPort inputPort : targetComp.getInputPorts()) {
                for (OutputPort outputPort : this.getComponentOutputPorts(inputPort, components)) {
                    O entityOutputPort = this.getEntityOutputPort(outputPort, caAlloc);
                    I entityInputPort = this.getEntityInputPort(inputPort, caAlloc);
                    if (!entityInputPort.getIncoming().isEmpty()) {
                        String portName = KernelModelElementUtils.computeFullyQualifiedName(entityInputPort);
                        if (portNumberMap.get(portName = portNameMap.getOrDefault(portName, portName)) == null) {
                            this.setPortName(entityInputPort, portName, portNumberMap, portNameMap);
                        }
                        E entity = this.getEntity(inputPort.getComponent(), caAlloc);
                        entityInputPort = this.createEntityInputPort(entity, inputPort, caAlloc);
                        this.setPortName(entityInputPort, portName, portNumberMap, portNameMap);
                    }
                    C connection = this.createEntityConnection(entityOutputPort, entityInputPort);
                    arch.getConnections().add(connection);
                }
            }
        }
        if (hasModelContext) {
            AnnotationUtils.instantiateAnnotationsRecursive(caAlloc);
            AnnotationUtils.instantiateAnnotationsRecursive(arch);
        }
        UniqueIDUtils.fixMissingIDs(caAlloc, (EObject)topLevelComponent);
        UniqueIDUtils.fixMissingIDs(arch, (EObject)topLevelComponent);
        return arch;
    }

    private void setPortName(I entityInputPort, String portName, Map<String, Integer> portNumberMap, Map<String, String> portNameMap) {
        int n = portNumberMap.getOrDefault(portName, 0) + 1;
        entityInputPort.setName(entityInputPort.getName() + n);
        portNameMap.put(KernelModelElementUtils.computeFullyQualifiedName(entityInputPort), portName);
        portNumberMap.put(portName, n);
    }

    protected abstract A createEntityArchitecture(Component var1);

    protected abstract T createAllocationTable(A var1, ComponentArchitecture var2, AllocationTableCollection var3);

    protected abstract E createEntity(Component var1);

    protected abstract I createEntityInputPort(InputPort var1);

    protected abstract O createEntityOutputPort(OutputPort var1);

    protected abstract C createEntityConnection(O var1, I var2);

    protected abstract E getEntity(Component var1, T var2);

    protected abstract I getEntityInputPort(InputPort var1, T var2);

    protected abstract O getEntityOutputPort(OutputPort var1, T var2);
}

