/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.IReadOnlyBehaviorSpecification;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.IComponentBehaviorDefinitionSpecification;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.impl.CausalityComponentSpecificationImpl;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.ProjectConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfigurationStore;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeSystem;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.utils.ProjectModelElementFactory;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class ComponentArchitectureUtils {
    public static ComponentArchitecture findComponentArchitecture(FileProject project, String name) {
        return (ComponentArchitecture)KernelModelElementUtils.findContentElementByNameAndClass((EObject)project, (String)name, ComponentArchitecture.class);
    }

    public static ComponentArchitecture findFirstComponentArchitecture(FileProject project) {
        return (ComponentArchitecture)EcoreUtils.pickFirstInstanceOf(ComponentArchitecture.class, (List)project.getRootElements());
    }

    public static ComponentArchitecture findComponentArchitectureInProjectByTopComponentName(FileProject project, String compName) {
        EList compArchitectures = EcoreUtils.pickInstanceOf(ComponentArchitecture.class, (List)project.getRootElements());
        for (ComponentArchitecture ca : compArchitectures) {
            Component topComp = ca.getTopComponent();
            if (topComp == null || !topComp.getName().equals(compName)) continue;
            return ca;
        }
        return null;
    }

    public static Channel findChannel(Component component, String channelName) {
        for (Channel ch : component.getChannels()) {
            if (!ch.getName().equals(channelName)) continue;
            return ch;
        }
        return null;
    }

    public static Port findSourcePort(Component boundary, Port port) {
        while (!port.getIncoming().isEmpty()) {
            if ((port = (Port)((IConnection)port.getIncoming().get(0)).getSource()).getComponent() == boundary) break;
        }
        return port;
    }

    public static List<Port> findTargetPorts(Component boundary, Port port) {
        ArrayList<Port> targets = new ArrayList<Port>();
        if (port.getComponent() == boundary || ComponentArchitectureUtils.isAtomicComponent(port.getComponent())) {
            targets.add(port);
            return targets;
        }
        LinkedList<Port> explore = new LinkedList<Port>();
        explore.add(port);
        while (!explore.isEmpty()) {
            Port testee = (Port)explore.removeFirst();
            if (testee.getComponent() == boundary || ComponentArchitectureUtils.isAtomicComponent(testee.getComponent()) || testee.getOutgoing().isEmpty()) {
                targets.add(testee);
                continue;
            }
            for (Channel ch : testee.getOutgoingChannels()) {
                explore.add(ch.getTarget());
            }
        }
        return targets;
    }

    public static boolean isAtomicComponent(Component component) {
        return EcoreUtils.pickInstanceOf(Component.class, (List)component.getContainedElements()).isEmpty();
    }

    public static boolean hasBehaviorDefinitionSpecification(Component component) {
        return EcoreUtils.pickInstanceOf(IComponentBehaviorDefinitionSpecification.class, (List)component.getSpecifications()).size() != 0;
    }

    public static Set<Component> getComponentsWithoutBehaviorDefinition(Component component) {
        HashSet<Component> undefinedComponents = new HashSet<Component>();
        EList containedElements = component.getContainedElements();
        if (containedElements.size() == 0 && !ComponentArchitectureUtils.hasBehaviorDefinitionSpecification(component)) {
            undefinedComponents.add(component);
        }
        for (IHierarchicElement element : containedElements) {
            if (!(element instanceof Component)) continue;
            Set<Component> subset = ComponentArchitectureUtils.getComponentsWithoutBehaviorDefinition((Component)element);
            undefinedComponents.addAll(subset);
        }
        return undefinedComponents;
    }

    public static String computeRelativeName(Component contextComponent, IVariableDefinition varDef) {
        if (varDef instanceof Port) {
            return KernelModelElementUtils.computeRelativeName((INamedElement)contextComponent, (INamedElement)((Port)varDef));
        }
        if (varDef instanceof DataStateVariable) {
            EObject comp = varDef.eContainer().eContainer();
            return KernelModelElementUtils.computeRelativeName((INamedElement)contextComponent, (INamedElement)((INamedElement)comp)) + "." + varDef.getVar().getIdentifier();
        }
        return "UNKNOWN";
    }

    public static Component getEnclosingComponent(EObject element) {
        EObject iterator = element;
        while (iterator.eContainer() != null && !(iterator.eContainer() instanceof Component)) {
            iterator = iterator.eContainer();
        }
        return (Component)iterator.eContainer();
    }

    public static List<Component> getEnclosingComponents(EObject element) {
        Component iterator = ComponentArchitectureUtils.getEnclosingComponent(element);
        ArrayList<Component> result = new ArrayList<Component>();
        while (iterator != null) {
            result.add(iterator);
            iterator = ComponentArchitectureUtils.getEnclosingComponent((EObject)iterator);
        }
        return result;
    }

    public static String getEnclosingComponentsAsPath(EObject element) {
        List<Component> enclosingComps = ComponentArchitectureUtils.getEnclosingComponents(element);
        Iterator<Component> it = enclosingComps.iterator();
        if (!it.hasNext()) {
            return "";
        }
        Object res = it.next().getName();
        while (it.hasNext()) {
            res = it.next().getName() + "." + (String)res;
        }
        return res;
    }

    public static void setCausality(Component component, boolean causality) {
        for (IModelElementSpecification spec : component.getSpecifications()) {
            if (!(spec instanceof CausalityComponentSpecificationImpl)) continue;
            ICommandStackService.getInstance().runAsCommand((EObject)component, () -> ((CausalityComponentSpecificationImpl)spec).setStronglyCausal(causality));
        }
    }

    public static Port computeSourcePort(Port target) {
        EList<Channel> channels = target.getIncomingChannels();
        if (channels.size() != 0) {
            return ((Channel)channels.get(0)).getSource();
        }
        return null;
    }

    public static DataDictionary findDataDictionary(Component comp) {
        FileProject fp = (FileProject)EcoreUtils.getFirstParentWithType((EObject)comp, FileProject.class);
        return DataDictionaryUtils.findDataDictionary((FileProject)fp);
    }

    public static Component getProperParentComponent(IModelElementSpecification spec) {
        return (Component)KernelModelElementUtils.getParentElement((EObject)spec, Component.class, (boolean)true);
    }

    public static EList<Component> getAllSubComponentRecursively(Component parent) {
        return EcoreUtils.getChildrenWithType((EObject)parent, Component.class);
    }

    public static boolean hasReadOnlyBehaviorSpecification(Component component) {
        EList list = EcoreUtils.pickInstanceOf(IComponentBehaviorDefinitionSpecification.class, (List)component.getSpecifications());
        return list.size() != 1 ? false : list.get(0) instanceof IReadOnlyBehaviorSpecification;
    }

    public static boolean containsReadOnlyBehaviorSpecification(EObject selection) {
        if (selection instanceof Component) {
            return ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification((Component)selection);
        }
        if (selection instanceof ComponentArchitecture) {
            Component rootComponent = ((ComponentArchitecture)selection).getTopComponent();
            EList<Component> subComponentsList = rootComponent.getSubComponents();
            for (Component c : subComponentsList) {
                if (!ComponentArchitectureUtils.hasReadOnlyBehaviorSpecification(c)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static ComponentArchitecture createTemporaryComponentArchitecture(Component copiedComponent, DataDictionary dd) {
        FileProject pro = ProjectModelElementFactory.createFileProject((String)"Temp", (ProjectConfiguration)ProjectModelElementFactory.createProjectConfiguration((ITypeSystem)ExpressionModelElementFactory.createMicroTypesystem()));
        Component topComponent = ComponentModelElementFactory.createComponentArchitecture(pro, "TempCompArch", copiedComponent.getName());
        if (dd != null) {
            pro.getRootElements().add((Object)((IProjectRootElement)EcoreUtils.copy((EObject)dd)));
        }
        for (InputPort inPort : copiedComponent.getInputPorts()) {
            InputPort createdInputPort = ComponentModelElementFactory.createInputPortAndAttach(topComponent, inPort.getName(), (IType)EcoreUtils.copy((EObject)inPort.getVariableType()), (IExpressionTerm)EcoreUtils.copy((EObject)inPort.getInitialValue()));
            ComponentModelElementFactory.createChannelAndAttach(topComponent, "", createdInputPort, inPort);
        }
        for (OutputPort outPort : copiedComponent.getOutputPorts()) {
            OutputPort createdOutputPort = ComponentModelElementFactory.createOutputPortAndAttach(topComponent, outPort.getName(), (IType)EcoreUtils.copy((EObject)outPort.getVariableType()), (IExpressionTerm)EcoreUtils.copy((EObject)outPort.getInitialValue()));
            ComponentModelElementFactory.createChannelAndAttach(topComponent, "", outPort, createdOutputPort);
        }
        topComponent.getContainedElements().add((Object)copiedComponent);
        ComponentModelElementFactory.createExecutionConfig(pro, "Temporary Execution Configuration");
        UniqueIDUtils.generateAllIDs((EObject)pro);
        ComponentArchitectureUtils.setExecutionConfigReferencedID(pro);
        ComponentArchitecture compArch = null;
        for (IProjectRootElement element : pro.getRootElements()) {
            if (!(element instanceof ComponentArchitecture) || !element.getName().equals("TempCompArch")) continue;
            compArch = (ComponentArchitecture)element;
        }
        return compArch;
    }

    public static void setExecutionConfigReferencedID(FileProject project) {
        int ComponentArchitectureID = 0;
        ExecutionConfiguration executionConfiguration = null;
        for (IProjectRootElement element : project.getRootElements()) {
            if (element instanceof ComponentArchitecture && element.getName().equals("TempCompArch")) {
                ComponentArchitectureID = element.getId();
            }
            if (!(element instanceof ExecutionConfigurationStore)) continue;
            executionConfiguration = (ExecutionConfiguration)((ExecutionConfigurationStore)element).getConfigurations().get(0);
        }
        if (ComponentArchitectureID != 0 && executionConfiguration != null) {
            executionConfiguration.setIdReference(ComponentArchitectureID);
        }
    }
}

