/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.utils;

import org.fortiss.af3.component.model.AF3ComponentFactory;
import org.fortiss.af3.component.model.CausalityComponentSpecification;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.ComponentSpecificationsContainer;
import org.fortiss.af3.component.model.DataDictionaryRefSpec;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfigurationStore;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.utils.ProjectModelElementFactory;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;

public final class ComponentModelElementFactory {
    public static ComponentArchitecture createComponentArchitecture(Component root) {
        ComponentArchitecture arch = AF3ComponentFactory.eINSTANCE.createComponentArchitecture();
        arch.setName("Component Architecture");
        arch.getContainedElements().add((Object)root);
        return arch;
    }

    public static ComponentArchitecture createComponentArchitecture() {
        ComponentArchitecture arch = AF3ComponentFactory.eINSTANCE.createComponentArchitecture();
        arch.setName("Component Architecture");
        Component hiddenRoot = ComponentModelElementFactory.createComponent("Component Architecture", "");
        arch.getContainedElements().add((Object)hiddenRoot);
        return arch;
    }

    public static Component createComponentArchitecture(FileProject project, String caName, String rootName) {
        ComponentArchitecture componentArchitecture = ComponentModelElementFactory.createComponentArchitecture();
        componentArchitecture.setName(caName);
        project.getRootElements().add((Object)componentArchitecture);
        Component rootComponent = componentArchitecture.getTopComponent();
        rootComponent.setName(rootName);
        componentArchitecture.getContainedElements().add((Object)rootComponent);
        return rootComponent;
    }

    public static Component createComponent() {
        return ComponentModelElementFactory.createComponent("Component", "");
    }

    public static Component createComponent(String name, String comment) {
        return ComponentModelElementFactory.createComponent(name, comment, false);
    }

    public static Component createComponent(String name, String comment, boolean stronglyCausal) {
        Component component = AF3ComponentFactory.eINSTANCE.createComponent();
        component.setName(name);
        component.setComment(comment);
        CausalityComponentSpecification spec = AF3ComponentFactory.eINSTANCE.createCausalityComponentSpecification();
        spec.setStronglyCausal(stronglyCausal);
        component.getSpecifications().add((Object)spec);
        LayoutModelElementFactory.createNodeElementLayout((ILayoutedModelElement)component);
        LayoutDataUtils.setNodeSize((ILayoutedModelElement)component, (int)216, (int)72);
        return component;
    }

    public static Component createComponentAndAttach(Component parent, String name, String comment, boolean stronglyCausal) {
        Component sub = ComponentModelElementFactory.createComponent(name, comment, stronglyCausal);
        parent.getContainedElements().add((Object)sub);
        return sub;
    }

    public static Component createComponentAndAttach(Component parent, String name, boolean stronglyCausal) {
        return ComponentModelElementFactory.createComponentAndAttach(parent, name, "", stronglyCausal);
    }

    public static Channel createChannel() {
        return ComponentModelElementFactory.createChannel("", "");
    }

    public static Channel createChannel(String name, String comment) {
        Channel channel = AF3ComponentFactory.eINSTANCE.createChannel();
        channel.setName(name);
        channel.setComment(comment);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)channel);
        return channel;
    }

    public static Channel createChannelAndAttach(Component parent, String name, Port source, Port target) {
        Channel ch = ComponentModelElementFactory.createChannel(name, name);
        parent.getChannels().add((Object)ch);
        ch.setSource((IConnector)source);
        ch.setTarget((IConnector)target);
        return ch;
    }

    public static OutputPort createOutputPort(String name, String comment, IType portType, IExpressionTerm initialValue) {
        OutputPort port = AF3ComponentFactory.eINSTANCE.createOutputPort();
        port.setName(name);
        port.setComment(comment);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)port);
        ComponentModelElementFactory.createPortSpecification(port, portType, initialValue);
        return port;
    }

    public static OutputPort createOutputPort(String name, String comment) {
        return ComponentModelElementFactory.createOutputPort(name, comment, (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)ExpressionModelElementFactory.createNoVal());
    }

    public static OutputPort createOutputPortAndAttach(Component parentComponent, String name, IType portType, IExpressionTerm initialValue) {
        OutputPort outputPort = ComponentModelElementFactory.createOutputPort(name, name, portType, initialValue);
        parentComponent.getConnectors().add((Object)outputPort);
        return outputPort;
    }

    public static InputPort createInputPort(String name, String comment, IType portType, IExpressionTerm initialValue) {
        InputPort port = AF3ComponentFactory.eINSTANCE.createInputPort();
        port.setName(name);
        port.setComment(comment);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)port);
        ComponentModelElementFactory.createPortSpecification(port, portType, initialValue);
        return port;
    }

    public static InputPort createInputPort(String name, String comment) {
        return ComponentModelElementFactory.createInputPort(name, comment, (IType)ExpressionModelElementFactory.intType(), (IExpressionTerm)ExpressionModelElementFactory.createNoVal());
    }

    public static InputPort createInputPortAndAttach(Component parentComponent, String name, IType portType, IExpressionTerm initialValue) {
        InputPort inputPort = ComponentModelElementFactory.createInputPort(name, name, portType, initialValue);
        parentComponent.getConnectors().add((Object)inputPort);
        return inputPort;
    }

    public static void createPortSpecification(Port port, IType portType, IExpressionTerm initialValue) {
        PortSpecification spec = AF3ComponentFactory.eINSTANCE.createPortSpecification();
        spec.setType(portType);
        spec.setInitialValue(initialValue);
        port.getSpecifications().add((Object)spec);
    }

    public static ExecutionConfiguration createExecutionConfig(FileProject project, String executionConfigurationName) {
        ExecutionConfigurationStore store = ProjectModelElementFactory.createExecutionConfigurationStore();
        project.getRootElements().add((Object)store);
        ExecutionConfiguration executionConfiguration = ProjectModelElementFactory.createExecutionConfiguration();
        executionConfiguration.setName(executionConfigurationName);
        store.getConfigurations().add((Object)executionConfiguration);
        return executionConfiguration;
    }

    public static ComponentSpecificationsContainer createComponentSpecificationsContainer() {
        return AF3ComponentFactory.eINSTANCE.createComponentSpecificationsContainer();
    }

    public static DataDictionaryRefSpec createDataDictionaryRefSpec(IModelElement parent, DataDictionary refDictionary) {
        DataDictionaryRefSpec ddRef = AF3ComponentFactory.eINSTANCE.createDataDictionaryRefSpec();
        ddRef.setSpecificationOf(parent);
        ddRef.setDataDictionary(refDictionary);
        return ddRef;
    }
}

