/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.utils;

import org.fortiss.af3.component.model.generator.ComponentFunction;
import org.fortiss.af3.component.model.generator.ComponentProgram;
import org.fortiss.af3.component.model.generator.LocalFunction;

public class ComponentProgramUtils {
    public static ComponentFunction findComponentFunctionByName(String name, ComponentProgram program) {
        if (program.getClearInputsFunction().getFunction().getName().equals(name)) {
            return program.getClearInputsFunction();
        }
        if (program.getClearOutputsFunction().getFunction().getName().equals(name)) {
            return program.getClearOutputsFunction();
        }
        if (program.getInitializeFunction().getFunction().getName().equals(name)) {
            return program.getInitializeFunction();
        }
        if (program.getPerformStepFunction().getFunction().getName().equals(name)) {
            return program.getPerformStepFunction();
        }
        for (ComponentProgram sub : program.getSubPrograms()) {
            ComponentFunction subFun = ComponentProgramUtils.findComponentFunctionByName(name, sub);
            if (subFun == null) continue;
            return subFun;
        }
        return null;
    }

    public static LocalFunction findLocalFunctionByName(String name, ComponentProgram program) {
        for (LocalFunction fun : program.getLocalFunctions()) {
            if (!fun.getFunction().getName().equals(name)) continue;
            return fun;
        }
        for (ComponentProgram sub : program.getSubPrograms()) {
            LocalFunction subFun = ComponentProgramUtils.findLocalFunctionByName(name, sub);
            if (subFun == null) continue;
            return subFun;
        }
        return null;
    }
}

