/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.PortSpecification;
import org.fortiss.af3.component.model.behavior.IComponentBehaviorDefinitionSpecification;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ComponentUtils {
    public static List<Component> getAllSubComponentsRecursively(Component root) {
        ArrayList<Component> result = new ArrayList<Component>();
        ComponentUtils.componentSearch(root, result);
        return result;
    }

    private static List<Component> componentSearch(Component root, List<Component> result) {
        for (IHierarchicElement o : root.getContainedElements()) {
            if (!(o instanceof Component)) continue;
            result.add((Component)o);
            ComponentUtils.componentSearch((Component)o, result);
        }
        return result;
    }

    public static Component componentOf(EObject comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof Component) {
            return (Component)comp;
        }
        if (comp instanceof ComponentArchitecture) {
            return ((ComponentArchitecture)comp).getTopComponent();
        }
        return null;
    }

    public static List<Port> getPortChain(Port p) {
        ArrayList<Port> res = new ArrayList<Port>(ComponentUtils.getIncomingPortChain(p));
        res.addAll(ComponentUtils.getOutgoingPortChain(p));
        res.add(p);
        return res;
    }

    public static List<Port> getIncomingPortChain(Port p) {
        ArrayList<Port> neighbours = new ArrayList<Port>();
        for (Channel c : p.getIncomingChannels()) {
            neighbours.add(c.getSource());
        }
        ArrayList<Port> res = new ArrayList<Port>(neighbours);
        for (Port p2 : neighbours) {
            res.addAll(ComponentUtils.getIncomingPortChain(p2));
        }
        return res;
    }

    public static List<Port> getOutgoingPortChain(Port p) {
        ArrayList<Port> neighbours = new ArrayList<Port>();
        for (Channel c : p.getOutgoingChannels()) {
            neighbours.add(c.getTarget());
        }
        ArrayList<Port> res = new ArrayList<Port>(neighbours);
        for (Port p2 : neighbours) {
            res.addAll(ComponentUtils.getOutgoingPortChain(p2));
        }
        return res;
    }

    public static void removeNonBehavior(Component comp) {
        ComponentUtils.removeSpecs((IModelElement)comp, spec -> spec instanceof IComponentBehaviorDefinitionSpecification);
    }

    public static void removeSpecs(IModelElement elt, Predicate<IModelElementSpecification> filter) {
        ArrayList<IModelElementSpecification> specsToRemove = new ArrayList<IModelElementSpecification>();
        for (IModelElementSpecification spec : elt.getSpecifications()) {
            if (filter.test(spec)) continue;
            specsToRemove.add(spec);
        }
        elt.getSpecifications().removeAll(specsToRemove);
    }

    public static void removeSubCompSpecs(Component comp, Predicate<IModelElementSpecification> filter) {
        for (Component subComp : comp.getSubComponents()) {
            for (Component subSubComp : subComp.getSubComponents()) {
                subComp.getContainedElements().remove((Object)subSubComp);
            }
            ComponentUtils.removeSpecs((IModelElement)subComp, filter);
        }
    }

    public static void removeAllSubCompSpecs(Component comp) {
        ComponentUtils.removeSubCompSpecs(comp, spec -> false);
    }

    public static void removeSubCompNames(Component comp) {
        for (Component subComp : comp.getSubComponents()) {
            subComp.setName("");
        }
    }

    public static boolean isTopComponent(Component c) {
        return c != null && c.getContainer() instanceof ComponentArchitecture;
    }

    public static void initializePortFromTemplate(Port port, Port template) {
        PortSpecification outPortSpec = template.getPortSpecification();
        IType type = (IType)EcoreUtils.copy((EObject)outPortSpec.getType());
        IExpressionTerm initialValue = (IExpressionTerm)EcoreUtils.copy((EObject)outPortSpec.getInitialValue());
        PortSpecification portSpecification = port.getPortSpecification();
        portSpecification.setType(type);
        portSpecification.setInitialValue(initialValue);
    }
}

