/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.utils;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.generator.ComponentFunction;
import org.fortiss.af3.component.model.generator.ComponentProgram;
import org.fortiss.af3.component.model.generator.GeneratorFactory;
import org.fortiss.af3.component.model.generator.LocalFunction;
import org.fortiss.af3.component.model.generator.LocalVariable;
import org.fortiss.af3.component.model.generator.PortVariable;
import org.fortiss.af3.component.model.generator.port.NoValArgument;
import org.fortiss.af3.component.model.generator.port.PortArgument;
import org.fortiss.af3.component.model.generator.port.PortFactory;
import org.fortiss.af3.component.model.generator.port.PortVariableOperationArgument;
import org.fortiss.af3.component.model.generator.port.ReadPortVariableExpression;
import org.fortiss.af3.component.model.generator.port.TestPortVariableExpression;
import org.fortiss.af3.component.model.generator.port.ValueArgument;
import org.fortiss.af3.component.model.generator.port.WritePortVariableStatement;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.TermsFactory;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class GeneratorModelElementFactory {
    public static PortVariable createPortVariable(String name, IType type) {
        PortVariable v = GeneratorFactory.eINSTANCE.createPortVariable();
        v.setVariable(ExpressionModelElementFactory.createVar((String)name));
        v.setType((IType)EcoreUtils.copy((EObject)type));
        return v;
    }

    public static LocalVariable createLocalVariable(String name, IType type) {
        LocalVariable v = GeneratorFactory.eINSTANCE.createLocalVariable();
        v.setVariable(ExpressionModelElementFactory.createVar((String)name));
        v.setType((IType)EcoreUtils.copy((EObject)type));
        return v;
    }

    public static ComponentProgram createComponentProgram(String name, ComponentFunction init, ComponentFunction performStep) {
        ComponentProgram result = GeneratorFactory.eINSTANCE.createComponentProgram();
        result.setName(name);
        result.setInitializeFunction(init);
        result.setPerformStepFunction(performStep);
        return result;
    }

    public static ComponentFunction createComponentFunction(String name, IType returnType, StatementSequence definition) {
        ComponentFunction fun = GeneratorFactory.eINSTANCE.createComponentFunction();
        UserdefinedFunction ufun = TermsFactory.eINSTANCE.createUserdefinedFunction();
        ufun.setName(name);
        fun.setFunction(ufun);
        fun.setReturnType((IType)EcoreUtils.copy((EObject)returnType));
        fun.setDefinition(definition);
        return fun;
    }

    public static LocalFunction createLocalFunction(String name, IType returnType, StatementSequence definition) {
        LocalFunction fun = GeneratorFactory.eINSTANCE.createLocalFunction();
        UserdefinedFunction ufun = TermsFactory.eINSTANCE.createUserdefinedFunction();
        ufun.setName(name);
        fun.setFunction(ufun);
        fun.setReturnType((IType)EcoreUtils.copy((EObject)returnType));
        fun.setDefinition(definition);
        return fun;
    }

    public static WritePortVariableStatement setPortVariable(PortVariable var, PortVariableOperationArgument arg) {
        WritePortVariableStatement stmt = PortFactory.eINSTANCE.createWritePortVariableStatement();
        stmt.setVariable(var);
        stmt.setArgument(arg);
        return stmt;
    }

    public static ReadPortVariableExpression getPortVariable(PortVariable var) {
        ReadPortVariableExpression exp = PortFactory.eINSTANCE.createReadPortVariableExpression();
        exp.setVariable(var);
        return exp;
    }

    public static TestPortVariableExpression testPortVariable(PortVariable var, PortVariableOperationArgument arg) {
        TestPortVariableExpression exp = PortFactory.eINSTANCE.createTestPortVariableExpression();
        exp.setVariable(var);
        exp.setArgument(arg);
        return exp;
    }

    public static NoValArgument noValArgument() {
        return PortFactory.eINSTANCE.createNoValArgument();
    }

    public static PortArgument portArgument(PortVariable var) {
        PortArgument arg = PortFactory.eINSTANCE.createPortArgument();
        arg.setPortVariable(var);
        return arg;
    }

    public static ValueArgument valueArgument(IExpressionTerm value) {
        ValueArgument arg = PortFactory.eINSTANCE.createValueArgument();
        arg.setValue(value);
        return arg;
    }
}

