/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.component.variability;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.fortiss.af3.component.model.AF3ComponentPackage;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.analysis.IProductLineTranslation;
import org.fortiss.variability.analysis.constraint.ProductLineConstraintBase;
import org.fortiss.variability.analysis.constraint.QuantifierVariable;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;

class MutuallyExclusiveInputsConstraint
extends ProductLineConstraintBase {
    private static final EClass CHANNEL_ECLASS = AF3ComponentPackage.Literals.CHANNEL;

    public MutuallyExclusiveInputsConstraint(IProductLineTranslation translation) {
        super(translation);
    }

    public BoolExpr createBody() {
        Expr c1 = this.getZ3Variable("c1");
        Expr c2 = this.getZ3Variable("c2");
        Context context = this.translation.getContext();
        FuncDecl targetFun = this.translation.getAttributeReferenceFunctionDeclaration(CHANNEL_ECLASS, "target");
        Expr nullTarget = this.translation.getNullElement(AF3ComponentPackage.eINSTANCE.getPort());
        Expr c1Target = context.mkApp(targetFun, new Expr[]{c1});
        Expr c2Target = context.mkApp(targetFun, new Expr[]{c2});
        BoolExpr c1TargetNotNull = context.mkNot((Expr)context.mkEq(c1Target, nullTarget));
        BoolExpr c2TargetNotNull = context.mkNot((Expr)context.mkEq(c2Target, nullTarget));
        BoolExpr targetEqual = context.mkEq(c1Target, c2Target);
        BoolExpr channelUnequal = context.mkNot((Expr)context.mkEq(c1, c2));
        return context.mkAnd(new Expr[]{targetEqual, channelUnequal, c1TargetNotNull, c2TargetNotNull});
    }

    public QuantifierVariable[] getQuantifierVariables() {
        return new QuantifierVariable[]{new QuantifierVariable(CHANNEL_ECLASS, "c1"), new QuantifierVariable(CHANNEL_ECLASS, "c2")};
    }

    public String getConstraintName() {
        return "Mutually Exclusive Input Constraint";
    }

    public String createErrorMessage(List<EObject> violatingObjects, VariantConfiguration violatingConfiguration) {
        Object componentStr = "";
        if (violatingObjects.size() > 0) {
            EObject c0 = violatingObjects.get(0);
            Component comp = (Component)EcoreUtils.getFirstParentWithType((EObject)c0, Component.class);
            componentStr = " in component " + comp.getName();
        }
        return "The Channels " + Arrays.deepToString(violatingObjects.stream().filter(o -> o instanceof Channel).map(c -> ((Channel)c).getName()).filter(n -> n != null && n.length() > 0).toArray()) + (String)componentStr + " are not mutually exclusive for all model variants!";
    }

    public Collection<EClass> getTranslatedClasses() {
        return Arrays.asList(AF3ComponentPackage.eINSTANCE.getPort(), AF3ComponentPackage.eINSTANCE.getChannel());
    }

    public Collection<EReference> getTranslatedReferences() {
        return Arrays.asList((EReference)CHANNEL_ECLASS.getEStructuralFeature(6));
    }
}

