/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.conqat.lib.commons.reflect.ReflectionUtils;

public class LambdaUtils {
    private LambdaUtils() {
    }

    public static <T, S extends T> Collection<T> filter(Collection<S> collection, Predicate<S> filter, Supplier<Collection<T>> sup) {
        return LambdaUtils.filterStream(collection, filter).collect(Collectors.toCollection(sup));
    }

    public static <T, S extends T> Collection<T> filter(Collection<S> collection, Predicate<S> filter) {
        return LambdaUtils.filterList(collection, filter);
    }

    public static <S> Stream<S> filterStream(Collection<S> collection, Predicate<S> filter) {
        return collection.stream().filter(filter);
    }

    public static <S> Stream<S> filterStreamPar(Collection<S> collection, Predicate<S> filter) {
        return collection.parallelStream().filter(filter);
    }

    public static <T, S extends T> Set<T> filterSet(Collection<S> collection, Predicate<S> filter) {
        return LambdaUtils.filterStream(collection, filter).collect(Collectors.toSet());
    }

    public static <T, S extends T> List<T> filterList(Collection<S> collection, Predicate<S> filter) {
        return LambdaUtils.filterStream(collection, filter).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T, C> Collection<Class<? extends T>> filterTypes(Collection<Class<? extends T>> types, Class<? extends C> ... classifiers) {
        BiFunction<Class, Class, Boolean> isOfClassifier = (t, c) -> c.isAssignableFrom((Class<?>)t);
        Predicate<Class> typeClassifierFilter = t -> Stream.of(classifiers).map(c -> (Boolean)isOfClassifier.apply((Class)t, (Class)c)).reduce((b1, b2) -> b1 != false && b2 != false).orElse(true);
        return types.stream().filter(typeClassifierFilter).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T, C> Collection<T> filterByTypes(Collection<T> elements, Class<? extends C> ... classifiers) {
        return elements.stream().filter(e -> ReflectionUtils.isInstanceOfAll((Object)e, (Class[])classifiers)).collect(Collectors.toList());
    }

    public static <S, T, U extends T> Collection<T> filterByType(Collection<S> inCol, Class<T> typeFilter) {
        ArrayList outCol = new ArrayList();
        LambdaUtils.filterStream(inCol, e -> typeFilter.isAssignableFrom(e.getClass())).map(typeFilter::cast).forEach(e -> {
            boolean bl = outCol.add(e);
        });
        return outCol;
    }

    public static <S, T extends S, U extends T> Collection<T> filterByType(Collection<S> inCol, Collection<T> outCol, Class<T> typeFilter) {
        LambdaUtils.filterStream(inCol, e -> typeFilter.isAssignableFrom(e.getClass())).map(typeFilter::cast).forEach(e -> {
            boolean bl = outCol.add(e);
        });
        return outCol;
    }

    public static <S, T> Collection<T> filterType(Collection<S> inCol, Class<T> typeFilter) {
        ArrayList outCol = new ArrayList();
        LambdaUtils.filterStream(inCol, e -> typeFilter.isAssignableFrom(e.getClass())).map(typeFilter::cast).forEach(e -> {
            boolean bl = outCol.add(e);
        });
        return outCol;
    }

    public static <S, T extends S, U extends T> Collection<T> filterTypeSafe(Collection<S> inCol, Class<U> typeFilter) {
        ArrayList outCol = new ArrayList();
        LambdaUtils.filterStream(inCol, e -> typeFilter.isAssignableFrom(e.getClass())).map(typeFilter::cast).forEach(e -> {
            boolean bl = outCol.add(e);
        });
        return outCol;
    }

    public static <S, T> Optional<T> firstOfType(Collection<S> inCol, Class<T> typeFilter) {
        return LambdaUtils.getFirst(LambdaUtils.filterType(inCol, typeFilter));
    }

    public static <T, S extends T> Optional<T> getFirst(Collection<S> collection, Predicate<S> filter) {
        return LambdaUtils.filterStream(collection, filter).findFirst();
    }

    public static <T> Optional<T> getFirst(Collection<T> collection) {
        return collection.stream().findFirst();
    }

    public static boolean isAssignableFromAny(Collection<Class<?>> types, Class<?> testType) {
        return types.stream().anyMatch(t -> t.isAssignableFrom(testType));
    }

    public static boolean isAssignableFromAny(Collection<Class<?>> types, Object element) {
        return LambdaUtils.isAssignableFromAny(types, element.getClass());
    }

    public static <S, T> Collection<S> mapInOut(Collection<T> inColl, Function<T, S> mapper, Supplier<? extends Collection<S>> sup) {
        return inColl.parallelStream().map(mapper).collect(Collectors.toCollection(sup));
    }

    public static <S, T> Stream<S> mapIn(Collection<T> inColl, Function<T, S> mapper) {
        return inColl.parallelStream().map(mapper);
    }

    public static <S, T> Collection<S> mapOut(Stream<T> stream, Function<T, S> mapper, Supplier<? extends Collection<S>> sup) {
        return stream.map(mapper).collect(Collectors.toCollection(sup));
    }

    public static <S, T, R extends Stream<S>, U extends Collection<S>> Collection<S> flatMapInOut(Collection<T> inColl, Function<T, R> mapper, Supplier<U> sup) {
        return (Collection)inColl.parallelStream().flatMap(mapper).collect(Collectors.toCollection(sup));
    }

    public static <T> Stream<T> asStream(final Iterator<T> iterator) {
        Iterable iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

