/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.manufacturing.product.compositor;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.manufacturing.product.model.ManufacturingProduct;
import org.fortiss.af3.manufacturing.product.model.RecipeInputPort;
import org.fortiss.af3.manufacturing.product.model.RecipeOutputPort;
import org.fortiss.af3.manufacturing.product.model.RecipeSignal;
import org.fortiss.af3.manufacturing.product.util.ManufacturingProductModelElementFactory;
import org.fortiss.tooling.base.compose.ConnectionCompositorBase;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class RecipeConnectionCompositor
extends ConnectionCompositorBase<IHierarchicElement, EObject, EObject> {
    public boolean canConnect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        return target instanceof RecipeInputPort && source instanceof RecipeOutputPort;
    }

    public boolean connect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        ManufacturingProduct manufacturingProduct = (ManufacturingProduct)parent;
        EList<RecipeSignal> recipeSignals = manufacturingProduct.getRecipeSignals();
        boolean isRecipeSignalExisiting = recipeSignals.stream().anyMatch(s -> s.getSource().equals(source) && s.getTarget().equals(target));
        if (isRecipeSignalExisiting) {
            return false;
        }
        RecipeSignal connection = this.createConnection();
        UniqueIDUtils.prepareUniqueID((EObject)connection, (EObject)parent);
        connection.setName(connection.getName() + connection.getId());
        manufacturingProduct.getConnections().add((Object)connection);
        connection.setSource((IConnector)source);
        connection.setTarget((IConnector)target);
        return true;
    }

    protected RecipeSignal createConnection() {
        return ManufacturingProductModelElementFactory.createRecipeSignal("RecipeSequence");
    }

    public boolean canDisconnect(EObject connection) {
        return connection instanceof RecipeSignal;
    }
}

