/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.manufacturing.product.compositor;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.manufacturing.product.model.Recipe;
import org.fortiss.af3.manufacturing.product.model.StepInputPort;
import org.fortiss.af3.manufacturing.product.model.StepOutputPort;
import org.fortiss.af3.manufacturing.product.model.StepSignal;
import org.fortiss.af3.manufacturing.product.util.ManufacturingProductModelElementFactory;
import org.fortiss.tooling.base.compose.ConnectionCompositorBase;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class StepConnectionCompositor
extends ConnectionCompositorBase<IHierarchicElement, EObject, EObject> {
    public boolean canConnect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        return target instanceof StepInputPort && source instanceof StepOutputPort;
    }

    public boolean connect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        Recipe recipe = (Recipe)parent;
        EList<StepSignal> recipeSignals = recipe.getStepSignals();
        boolean isStepSignalExisiting = recipeSignals.stream().anyMatch(s -> s.getSource().equals(source) && s.getTarget().equals(target));
        if (isStepSignalExisiting) {
            return false;
        }
        StepSignal connection = this.createConnection();
        UniqueIDUtils.prepareUniqueID((EObject)connection, (EObject)parent);
        connection.setName(connection.getName() + connection.getId());
        recipe.getConnections().add((Object)connection);
        connection.setSource((IConnector)source);
        connection.setTarget((IConnector)target);
        return true;
    }

    protected StepSignal createConnection() {
        return ManufacturingProductModelElementFactory.createStepSignal("StepSequence");
    }

    public boolean canDisconnect(EObject connection) {
        return connection instanceof StepSignal;
    }
}

