/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.manufacturing.product.util;

import org.fortiss.af3.manufacturing.product.model.ManufacturingProduct;
import org.fortiss.af3.manufacturing.product.model.ProductFactory;
import org.fortiss.af3.manufacturing.product.model.Recipe;
import org.fortiss.af3.manufacturing.product.model.RecipeInputPort;
import org.fortiss.af3.manufacturing.product.model.RecipeOutputPort;
import org.fortiss.af3.manufacturing.product.model.RecipeSequenceInputPort;
import org.fortiss.af3.manufacturing.product.model.RecipeSequenceOutputPort;
import org.fortiss.af3.manufacturing.product.model.RecipeSignal;
import org.fortiss.af3.manufacturing.product.model.Step;
import org.fortiss.af3.manufacturing.product.model.StepInputPort;
import org.fortiss.af3.manufacturing.product.model.StepOutputPort;
import org.fortiss.af3.manufacturing.product.model.StepSequenceInputPort;
import org.fortiss.af3.manufacturing.product.model.StepSequenceOutputPort;
import org.fortiss.af3.manufacturing.product.model.StepSignal;
import org.fortiss.af3.platform.model.IPortSemantics;
import org.fortiss.af3.platform.model.IQueuingPort;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;

public class ManufacturingProductModelElementFactory {
    public static ManufacturingProduct createManufacturingProduct(String name) {
        ManufacturingProduct manufacturingProduct = ProductFactory.eINSTANCE.createManufacturingProduct();
        manufacturingProduct.setName(name);
        return manufacturingProduct;
    }

    public static Recipe createRecipe(String name) {
        Recipe recipe = ProductFactory.eINSTANCE.createRecipe();
        recipe.setName(name);
        return recipe;
    }

    public static Step createStep(String name) {
        Step step = ProductFactory.eINSTANCE.createStep();
        step.setName(name);
        return step;
    }

    public static RecipeSignal createRecipeSignal(String name) {
        RecipeSignal signal = ProductFactory.eINSTANCE.createRecipeSignal();
        signal.setName(name);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)signal);
        return signal;
    }

    public static RecipeSignal createRecipeSignal(RecipeOutputPort recipeOutputPort, RecipeInputPort recipeInputPort, String name) {
        RecipeSignal signal = ManufacturingProductModelElementFactory.createRecipeSignal(name);
        signal.setSource((IConnector)recipeOutputPort);
        signal.setTarget((IConnector)recipeInputPort);
        return signal;
    }

    public static StepSignal createStepSignal(String name) {
        StepSignal signal = ProductFactory.eINSTANCE.createStepSignal();
        signal.setName(name);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)signal);
        return signal;
    }

    public static StepSignal createStepSignal(StepOutputPort stepOutputPort, StepInputPort stepInputPort, String name) {
        StepSignal signal = ManufacturingProductModelElementFactory.createStepSignal(name);
        signal.setSource((IConnector)stepOutputPort);
        signal.setTarget((IConnector)stepInputPort);
        return signal;
    }

    public static RecipeInputPort createRecipeInputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return ManufacturingProductModelElementFactory.createRecipeSequenceInputPort(name);
        }
        return null;
    }

    public static RecipeOutputPort createRecipeOutputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return ManufacturingProductModelElementFactory.createRecipeSequenceOutputPort(name);
        }
        return null;
    }

    public static StepInputPort createStepInputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return ManufacturingProductModelElementFactory.createStepSequenceInputPort(name);
        }
        return null;
    }

    public static StepOutputPort createStepOutputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return ManufacturingProductModelElementFactory.createStepSequenceOutputPort(name);
        }
        return null;
    }

    public static RecipeSequenceOutputPort createRecipeSequenceOutputPort(String name) {
        RecipeSequenceOutputPort pOutPort = ProductFactory.eINSTANCE.createRecipeSequenceOutputPort();
        pOutPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pOutPort);
        return pOutPort;
    }

    public static RecipeSequenceInputPort createRecipeSequenceInputPort(String name) {
        RecipeSequenceInputPort pInPort = ProductFactory.eINSTANCE.createRecipeSequenceInputPort();
        pInPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pInPort);
        return pInPort;
    }

    public static StepSequenceOutputPort createStepSequenceOutputPort(String name) {
        StepSequenceOutputPort pOutPort = ProductFactory.eINSTANCE.createStepSequenceOutputPort();
        pOutPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pOutPort);
        return pOutPort;
    }

    public static StepSequenceInputPort createStepSequenceInputPort(String name) {
        StepSequenceInputPort pInPort = ProductFactory.eINSTANCE.createStepSequenceInputPort();
        pInPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pInPort);
        return pInPort;
    }
}

